# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Qt version of the debug client.
"""

from qt import PYSIGNAL

from AsyncIO import *
from DebugBase import *
import DebugClientBase


def DebugClientQAppHook():
    """
    Module function called by PyQt when the QApplication instance has been created.
    """
    if DebugClientBase.DebugClientInstance is not None:
        AsyncIO.setNotifiers(DebugClientBase.DebugClientInstance)

# Make the hook available to PyQt.
try:
    __builtins__.__dict__['__pyQtQAppHook__'] = DebugClientQAppHook
except:
    import __main__
    __main__.__builtins__.__dict__['__pyQtQAppHook__'] = DebugClientQAppHook


class DebugClient(DebugClientBase.DebugClientBase, AsyncIO, DebugBase):
    """
    Class implementing the client side of the debugger.

    This variant of the debugger implements a Qt debugger client
    by subclassing all relevant base classes.
    """
    def __init__(self):
        """
        Constructor
        """
        AsyncIO.__init__(self)
        
        DebugClientBase.DebugClientBase.__init__(self)
        
        DebugBase.__init__(self, self)
        
        self.variant = 'Qt-Version'

# We are normally called by the debugger to execute directly.

if __name__ == '__main__':
    debugClient = DebugClient()
    debugClient.main()
