# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to edit watchpoint properties.
"""

from qt import *

from EditWatchpointForm import EditWatchpointForm


class EditWatchpointDialog(EditWatchpointForm):
    """
    Class implementing a dialog to edit watchpoint properties.
    """
    def __init__(self, properties, parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param properties properties for the watchpoint (tuple)
                (condition, temporary flag, enabled flag, ignore count)
        @param parent the parent of this dialog
        @param name the widget name of this dialog
        @param modal flag indicating a modal dialog
        @param fl the window flags
        """
        EditWatchpointForm.__init__(self,parent,name,modal,fl)
        
        dummy = self.trUtf8("Dummy")
        
        cond, temp, enabled, count, special = properties
        
        # set the condition
        if special.isEmpty():
            self.conditionButton.setChecked(1)
            self.conditionEdit.setText(cond)
        else:
            self.specialButton.setChecked(1)
            self.specialEdit.setText(cond)
            self.specialCombo.setCurrentText(special)
        
        # set the ignore count
        self.ignoreSpinBox.setValue(count)
        
        # set the checkboxes
        self.temporaryCheckBox.setChecked(temp)
        self.enabledCheckBox.setChecked(enabled)
        
        if special.isEmpty():
            self.conditionEdit.setFocus()
        else:
            self.specialEdit.setFocus()
        
    def handleTextChanged(self, txt):
        """
        Private slot to handle the text changed signal of the condition line edit.
        
        @param txt text of the line edit (QString)
        """
        if self.conditionButton.isChecked():
            self.okButton.setEnabled(not self.conditionEdit.text().isEmpty())
        elif self.specialButton.isChecked():
            self.okButton.setEnabled(not self.specialEdit.text().isEmpty())
        else:
            # should not happen
            self.okButton.setEnabled(0)
        
    def getData(self):
        """
        Public method to retrieve the entered data.
        
        @return a tuple containing the watchpoints new properties
            (condition, temporary flag, enabled flag, ignore count)
        """
        if self.conditionButton.isChecked():
            return (self.conditionEdit.text(), 
                    self.temporaryCheckBox.isChecked(),
                    self.enabledCheckBox.isChecked(), 
                    self.ignoreSpinBox.value(),
                    QString(""))
        elif self.specialButton.isChecked():
            return (self.specialEdit.text(), 
                    self.temporaryCheckBox.isChecked(),
                    self.enabledCheckBox.isChecked(), 
                    self.ignoreSpinBox.value(),
                    self.specialCombo.currentText())
        else:
            # should not happen
            return (QString(""), 0, 0,  0, QString(""))
