# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the bookmark dialog of the helpviewer.
"""

import os

from qt import *

from BookmarkForm import BookmarkForm

class BookmarkDialog(BookmarkForm):
    """
    Class implementing the bookmark dialog of the helpviewer.
    
    This dialog is used to edit and delete individual bookmarks.
    They can be rearranged and their contents can be edited.
    """
    def __init__(self,parent,name=None,modal=0,fl=0):
        """
        Constructor
        
        @param parent the parent widget of this dialog (QWidget)
                This is usually the helpviewer main window.
        @param name the name of this dialog (string or QString)
        @param modal flag indicating a modal dialog (boolean)
        @param fl window flags for this dialog
        """
        BookmarkForm.__init__(self,parent,name,modal,fl)
        
        self.parent = parent
        
        self.bmListView.setSorting(-1)
        
        dummy = self.trUtf8('dummy')
        
    def populateBMListView(self):
        """
        Private function to set up the contents of the listview.
        """
        self.bmListView.clear()
        
        mBookmarks = self.parent.__class__.mBookmarks
        for i in range(mBookmarks["Names"].count()-1, -1, -1):
            itm = QListViewItem(self.bmListView, 
                    mBookmarks["Names"][i],
                    mBookmarks["Files"][i])
            itm.setRenameEnabled(0, 1)
            itm.setRenameEnabled(1, 1)
            
    def moveUp(self):
        """
        Private slot called to move the selected item up in the list.
        """
        itm = self.bmListView.currentItem()
        if itm is None:
            # nothing selected
            return
            
        itmAbove = itm.itemAbove()
        if itmAbove is None:
            # we're already at the top
            return
            
        itmAbove.moveItem(itm)
        
    def moveDown(self):
        """
        Private slot called to move the selected item down in the list.
        """
        itm = self.bmListView.currentItem()
        if itm is None:
            # nothing selected
            return
            
        itmBelow = itm.itemBelow()
        if itmBelow is None:
            # we're already at the end
            return
            
        itm.moveItem(itmBelow)
        
    def handleDelete(self):
        """
        Private slot called to delete a listview item.
        """
        itm = self.bmListView.currentItem()
        if itm is None:
            # nothing selected
            return
            
        self.bmListView.takeItem(itm)
        del itm
        
    def accept(self):
        """
        Private slot called if the Ok button is pressed.
        
        It updates the bookmarks list and writes it to
        the bookmarks file.
        """
        self.parent.__class__.mBookmarks["Names"] = QStringList()
        self.parent.__class__.mBookmarks["Files"] = QStringList()
        itm = self.bmListView.firstChild()
        while 1:
            self.parent.__class__.mBookmarks["Names"].append(itm.text(0))
            self.parent.__class__.mBookmarks["Files"].append(itm.text(1))
            itm = itm.nextSibling()
            if itm is None:
                break
        self.parent.writeBookmarks()
        BookmarkForm.accept(self)
        
    def show(self):
        """
        Public slot called to display this dialog.
        """
        self.populateBMListView()
        BookmarkForm.show(self)
