# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to preview the contents of an icon directory.
"""

import os.path

from qt import *

from IconsPreviewForm import IconsPreviewForm


class IconsPreviewDialog(IconsPreviewForm):
    """
    Class implementing a dialog to preview the contents of an icon directory.
    """
    def __init__(self, parent, dirName):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        @param dirName name of directory to show
        """
        IconsPreviewForm.__init__(self,parent)
        
        dummy = self.trUtf8("Dummy")
        
        dir = QDir(dirName)
        for icon in dir.entryList("*.png"):
            QIconViewItem(self.iconView, icon, 
                QPixmap(os.path.join(unicode(dirName), unicode(icon))))
