# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a JavaScript lexer with some additional methods.
"""

from qtext import QextScintillaLexerJavaScript
from qt import *

from Lexer import Lexer

class LexerJavaScript(QextScintillaLexerJavaScript, Lexer):
    """ 
    Subclass to implement some additional lexer dependant methods.
    """
    def __init__(self, parent=None, name=None):
        """
        Constructor
        
        @param parent parent widget of this lexer
        @param name name of this lexer
        """
        QextScintillaLexerJavaScript.__init__(self, parent, name)
        Lexer.__init__(self)
        
        self.commentString = QString("//~ ")
        self.streamCommentString = {
            'start' : QString('/* '),
            'end'   : QString(' */')
        }
        self.boxCommentString = {
            'start'  : QString('/* '),
            'middle' : QString(' * '),
            'end'    : QString(' */')
        }
