# -*- coding: utf-8 -*-

# Copyright (c) 2003 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the color dialog wizard dialog.
"""

import os

from qt import *

from KdeQt import KQMessageBox

from ColorDialogWizardForm import ColorDialogWizardForm

class ColorDialogWizardDialog(ColorDialogWizardForm):
    """
    Module implementing the color dialog wizard dialog.
    
    It displays a dialog for entering the parameters
    for the QColorDialog code generator.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        ColorDialogWizardForm.__init__(self, parent, None, 1)
        
        # to get around a quirk in PyQt if the subclass has no translatable strings
        dummy = self.trUtf8('Dummy')
        
    def testDlg(self):
        """
        Private method to test the selected options.
        """
        if self.rColor.isOn():
            if self.eColor.currentText().isEmpty():
                QColorDialog.getColor()
            else:
                coStr = str(self.eColor.currentText())
                if coStr.startswith('#'):
                    coStr = "QColor('%s')" % coStr
                elif not coStr.startswith('Qt.'):
                    coStr = "Qt.%s" % coStr
                try:
                    exec 'QColorDialog.getColor(%s)' % coStr
                except:
                    KQMessageBox.critical(None,
                        self.trUtf8("QColorDialog Wizard Error"),
                        self.trUtf8("""<p>The colour <b>%1</b> is not valid.</p>""")
                            .arg(coStr),
                        self.trUtf8("&OK"))

        elif self.rRGBA.isOn():
            rgba = qRgba(self.sRed.value(), self.sGreen.value(),
                self.sBlue.value(), self.sAlpha.value())
            QColorDialog.getRgba(rgba)
        
    def getCode(self, indLevel, indString):
        """
        Public method to get the source code.
        
        @param indLevel indentation level (int)
        @param indString string used for indentation (space or tab) (string)
        @return generated code (string)
        """
        # calculate our indentation level and the indentation string
        il = indLevel + 1
        istring = il * indString
        
        # now generate the code
        code = 'QColorDialog.'
        if self.rColor.isOn():
            code += 'getColor('
            if not self.eColor.currentText().isEmpty():
                col = str(self.eColor.currentText())
                if col.startswith('#'):
                    code += 'QColor("%s")' % col
                else:
                    code += col
            code += ')%s' % os.linesep
        elif self.rRGBA.isOn():
            code += 'getRgba('
            if self.eRGB.text().isEmpty():
                code += 'qRgba(%d, %d, %d, %d)' % \
                    (self.sRed.value(), self.sGreen.value(), self.sBlue.value(),
                    self.sAlpha.value())
            else:
                code += str(self.eRGB.text())
            code += ')%s' % os.linesep
            
        return code
        
    def handleRGBVar(self, text):
        """
        Private slot to handle the textChanged signal of eRGB.
        
        @param text the new text (QString)
        """
        if text.isEmpty():
            self.sRed.setEnabled(1)
            self.sGreen.setEnabled(1)
            self.sBlue.setEnabled(1)
            self.sAlpha.setEnabled(1)
            self.bTest.setEnabled(1)
        else:
            self.sRed.setEnabled(0)
            self.sGreen.setEnabled(0)
            self.sBlue.setEnabled(0)
            self.sAlpha.setEnabled(0)
            self.bTest.setEnabled(0)

    def handleColorVar(self, text):
        """
        Private slot to handle the textChanged signal of eColor.
        
        @param text the new text (QString)
        """
        if text.isEmpty() or text.startsWith('Qt.') or text.startsWith('#'):
            self.bTest.setEnabled(1)
        else:
            self.bTest.setEnabled(0)
