# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the writer class for writing an XML shortcuts file.
"""

import time

from qt import qApp, QString

from XMLWriterBase import XMLWriterBase
from Config import shortcutsFileFormatVersion

import Preferences

class ShortcutsWriter(XMLWriterBase):
    """
    Class implementing the writer class for writing an XML shortcuts file.
    """
    def __init__(self, file):
        """
        Constructor
        
        @param file open file (like) object for writing
        """
        XMLWriterBase.__init__(self, file)
        
        self.email = Preferences.getUser("Email")
        
    def writeXML(self):
        """
        Public method to write the XML to the file.
        """
        XMLWriterBase.writeXML(self)
        
        self._write('<!DOCTYPE Shortcuts SYSTEM "Shortcuts-%s.dtd">' % shortcutsFileFormatVersion)
        
        # add some generation comments
        self._write("<!-- Eric3 keyboard shortcuts -->")
        self._write("<!-- Saved: %s -->" % time.strftime('%Y-%m-%d, %H:%M:%S'))
        self._write("<!-- Author: %s -->" % self.escape("%s" % self.email))
        
        # add the main tag
        self._write('<Shortcuts version="%s">' % shortcutsFileFormatVersion)
        
        for act in qApp.mainWidget().getProject().getActions():
            self._write('  <Shortcut category="Project">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getActions():
            self._write('  <Shortcut category="General">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getDebugger().getActions():
            self._write('  <Shortcut category="Debug">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getWizards().getActions():
            self._write('  <Shortcut category="Wizards">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getViewManager().getActions('edit'):
            self._write('  <Shortcut category="Edit">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getViewManager().getActions('file'):
            self._write('  <Shortcut category="File">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getViewManager().getActions('search'):
            self._write('  <Shortcut category="Search">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getViewManager().getActions('view'):
            self._write('  <Shortcut category="View">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getViewManager().getActions('macro'):
            self._write('  <Shortcut category="Macro">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        for act in qApp.mainWidget().getViewManager().getActions('bookmark'):
            self._write('  <Shortcut category="Bookmarks">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
        
        actions = qApp.mainWidget().getViewManager().getActions('window')
        if actions:
            for act in actions:
                self._write('  <Shortcut category="Window">')
                self._write('    <Name>%s</Name>' % act.name())
                self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
                self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
                self._write('  </Shortcut>')
        
        actions = qApp.mainWidget().getRefactoring().getActions()
        for act in actions:
            self._write('  <Shortcut category="Refactoring">')
            self._write('    <Name>%s</Name>' % act.name())
            self._write('    <Accel>%s</Accel>' % self.escape("%s" % QString(act.accel())))
            self._write('    <AltAccel>%s</AltAccel>' % self.escape("%s" % QString(act.alternateAccel())))
            self._write('  </Shortcut>')
    
        # add the main end tag
        self._write("</Shortcuts>")
