#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric3 Unittest

This is the main Python script that performs the neccessary initialization
of the unittest module and starts the Qt event loop. This is a standalone 
version of the integrated unittest module.
"""

import sys, os

if "--nokde" in sys.argv:
    del sys.argv[sys.argv.index("--nokde")]
    os.environ["e3nokde"] = "1"

from Utilities import Startup


def createMainWidget(argv, qtDir):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @param qtDir directory of the Qt installation (string)
    @return reference to the main widget (QWidget)
    """
    from PyUnit.UnittestDialog import UnittestDialog
    try:
        fn = argv[1]
    except IndexError:
        fn = None
    return UnittestDialog(fn)

def main():
    """
    Main entry point into the application.
    """
    options = [\
        ("--nokde" , "don't use KDE widgets"),
    ]
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric3 Unittest",
                                  "file",
                                  "Graphical unit test application",
                                  options)
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget,
                                   [('!+file', '')])
    sys.exit(res)

if __name__ == '__main__':
    main()
