#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2007 Detlev Offenbach <detlev@die-offenbachs.de>
#
# This is the install script for eric3's translation files.

"""
Installation script for the eric3 IDE translation files.
"""

import sys
import os
import shutil
import glob

from qt import QDir

try:
    from eric3config import getConfig
except ImportError:
    print "The eric3 IDE doesn't seem to be installed. Aborting."
    sys.exit(1)
    
def getConfigDir():
    """
    Global function to get the name of the directory storing the config data.
    
    @return directory name of the config dir (string)
    """
    if sys.platform == "win32":
        cdn = "_eric3"
    else:
        cdn = ".eric3"
        
    hp = QDir.homeDirPath()
    dn = QDir(hp)
    dn.mkdir(cdn)
    hp.append("/").append(cdn)
    return unicode(QDir.convertSeparators(hp))

    
# Define the globals.
progName = None
configDir = getConfigDir()
privateInstall = 0

def usage(rcode = 2):
    """Display a usage message and exit.

    rcode is the return code passed back to the calling process.
    """
    global progName, configDir

    print
    print "Usage:"
    print "    %s [-hp]" % (progName)
    print "where:"
    print "    -h        display this help message"
    print "    -p        install into the private area (%s)" % (configDir)

    sys.exit(rcode)

def installTranslations():
    """Install the translation files into the right place.
    """
    global privateInstall, configDir
    
    if privateInstall:
        targetDir = configDir
    else:
        targetDir = getConfig('ericDir')
    
    for fn in glob.glob(os.path.join('eric', 'i18n', '*.qm')):
        shutil.copy2(fn, targetDir)
    
def main(argv):
    """The main function of the script.

    argv is the list of command line arguments.
    """
    import getopt

    # Parse the command line.
    global progName, privateInstall
    progName = os.path.basename(argv[0])

    try:
        optlist, args = getopt.getopt(argv[1:],"hp")
    except getopt.GetoptError:
        usage()

    global platBinDir
    
    depChecks = 1

    for opt, arg in optlist:
        if opt == "-h":
            usage(0)
        elif opt == "-p":
            privateInstall = 1
        
    installTranslations()

if __name__ == "__main__":
    try:
        main(sys.argv)
    except SystemExit:
        raise
    except:
        print \
"""An internal error occured.  Please report all the output of the program,
including the following traceback, to eric-bugs@die-offenbachs.de.
"""
        raise
