# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a Bash lexer with some additional methods.
"""

from PyQt4.Qsci import QsciLexerBash
from PyQt4.QtCore import QString

from Lexer import Lexer
import Preferences

class LexerBash(QsciLexerBash, Lexer):
    """ 
    Subclass to implement some additional lexer dependant methods.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget of this lexer
        """
        QsciLexerBash.__init__(self, parent)
        Lexer.__init__(self)
        
        self.commentString = QString("#")
    
    def initProperties(self):
        """
        Public slot to initialize the properties.
        """
        self.setFoldComments(Preferences.getEditor("BashFoldComment"))
        self.setFoldCompact(Preferences.getEditor("AllFoldCompact"))
