# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2009 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the search dialog for the helpviewer.
"""

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from KdeQt import KQMessageBox

from Ui_SearchDialog import Ui_SearchDialog

class SearchDialog(QDialog, Ui_SearchDialog):
    """
    Module implementing the search dialog for the helpviewer.
    """
    def __init__(self, parent = None, name = QString(),
                 fl = Qt.WindowFlags(Qt.Widget)):
        """
        Constructor
        
        @param parent parent widget of this dialog (QWidget)
        @param name object name of the dialog (QString)
        @param fl window flags
        """
        QDialog.__init__(self, parent, fl)
        self.setupUi(self)
        self.setObjectName(name)
        
        self.findButton = self.buttonBox.addButton(\
            self.trUtf8("Find"), QDialogButtonBox.ActionRole)
        self.findButton.setEnabled(False)
        self.findButton.setDefault(True)
        
        self.findHistory = QStringList()
        self.havefound = False

    def on_findtextCombo_editTextChanged(self, txt):
        """
        Private slot to enable/disable the find buttons.
        """
        self.findButton.setEnabled(not txt.isEmpty())

    def on_buttonBox_clicked(self, button):
        """
        Private slot called by a button of the button box clicked.
        
        @param button button that was clicked (QAbstractButton)
        """
        if button == self.findButton:
            self.on_findButton_clicked()
        
    @pyqtSignature("")
    def on_findButton_clicked(self):
        """
        Private slot to find the entered text in the displayed page.
        """
        txt = self.findtextCombo.currentText()
        
        # This moves any previous occurrence of this statement to the head
        # of the list and updates the combobox
        self.findHistory.removeAll(txt)
        self.findHistory.prepend(txt)
        self.findtextCombo.clear()
        self.findtextCombo.addItems(self.findHistory)
        
        self.__findNextPrev(self.backwardsButton.isChecked())

    def __findNextPrev(self, backwards):
        """
        Private slot to find the next occurrence of text.
        
        @param backwards flag indicating a backwards search (boolean)
        """
        if not self.havefound or self.findtextCombo.currentText().isEmpty():
            self.showFind()
            return
        
        if not self.parent().currentBrowser().findNextPrev(
                self.findtextCombo.currentText(), 
                self.caseCheckBox.isChecked(), 
                self.wordCheckBox.isChecked(), 
                backwards):
            KQMessageBox.information(self, self.windowTitle(),
                self.trUtf8("'%1' was not found.").arg(self.findtextCombo.currentText()))

    def findNext(self):
        """
        Public slot to find the next occurrence.
        """
        self.__findNextPrev(False)

    def findPrevious(self):
        """
        Public slot to find the previous occurrence.
        """
        self.__findNextPrev(True)

    def showFind(self):
        """
        Public method to display this dialog.
        """
        self.havefound = True
        
        self.findtextCombo.clear()
        self.findtextCombo.addItems(self.findHistory)
        self.findtextCombo.setEditText('')
        self.findtextCombo.setFocus()
        
        self.caseCheckBox.setChecked(False)
        self.wordCheckBox.setChecked(False)
        self.forwardButton.setChecked(True)
        
        self.wordCheckBox.setEnabled(
            self.parent().currentBrowser().supportsSearchWholeWord())
        
        if self.parent().currentBrowser().hasSelection():
            self.findtextCombo.setEditText(self.parent().currentBrowser().selectedText())
        
        self.show()
