#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2009 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric4 Configure

This is the main Python script to configure the eric4 IDE from the outside.
"""

import sys
import os

# disable the usage of KDE widgets, if requested
sys.e4nokde = False
if "--nokde" in sys.argv:
    del sys.argv[sys.argv.index("--nokde")]
    sys.e4nokde = True
else:
    sys.e4nokde = os.getenv("e4nokde") is not None and os.getenv("e4nokde") == "1"

# make ThirdParty package available as a packages repository
try:
    import pygments
except ImportError:
    sys.path.insert(2, os.path.join(os.path.dirname(__file__), "ThirdParty", "Pygments"))

from Utilities import Startup

import Preferences


def createMainWidget(argv):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @return reference to the main widget (QWidget)
    """
    from Preferences.ConfigurationDialog import ConfigurationWindow
    w = ConfigurationWindow()
    w.show()
    w.showConfigurationPageByName("empty")
    return w

def main():
    """
    Main entry point into the application.
    """
    options = [\
        ("--nokde" , "don't use KDE widgets"),
    ]
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric4 Configure",
                                  "",
                                  "Configuration editor for eric4",
                                  options)
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget)
    sys.exit(res)

if __name__ == '__main__':
    main()
