# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the variables filter dialog.
"""

from qt import *

from UI.Info import *
from Config import ConfigVarTypeDispStrings
import Preferences
from VariablesFilterForm import VariablesFilterForm


class VariablesFilterDialog(VariablesFilterForm):
    """
    Class implementing the variables filter dialog.
    
    It opens a dialog window for the configuration of the variables type
    filter to be applied during a debugging session.
    """
    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param parent parent widget of this dialog (QWidget)
        @param name name of this dialog (string or QString)
        @param modal flag to indicate a modal dialog (boolean)
        @param fl window flags
        """
        VariablesFilterForm.__init__(self,parent,name,modal,fl)

        self.setCaption(self.trUtf8('%1 - Variables Filter')
            .arg(Program))

        lDefaultFilter, gDefaultFilter = Preferences.getVarFilters()
        
        #populate the listboxes and set the default selection
        for lb in self.localsListbox, self.globalsListbox:
            for ts in ConfigVarTypeDispStrings:
                lb.insertItem(self.trUtf8(ts))
                
        for filterIndex in lDefaultFilter:
            self.localsListbox.setSelected(filterIndex, 1)
        for filterIndex in gDefaultFilter:
            self.globalsListbox.setSelected(filterIndex, 1)

    def getSelection(self):
        """
        Public slot to retrieve the current selections.
        
        @return A tuple of lists of integer values. The first list is the locals variables
            filter, the second the globals variables filter.
        """
        lList = []
        gList = []
        for i in range(self.localsListbox.count()):
            if self.localsListbox.isSelected(i):
                lList.append(i)
        for i in range(self.globalsListbox.count()):
            if self.globalsListbox.isSelected(i):
                gList.append(i)
        return (lList, gList)
        
    def setSelection(self, lList, gList):
        """
        Public slot to set the current selection. 
        
        @param lList local variables filter (list of int)
        @param gList global variables filter (list of int)
        """
        for filterIndex in lList:
            self.localsListbox.setSelected(filterIndex, 1)        
        for filterIndex in gList:
            self.globalsListbox.setSelected(filterIndex, 1)        

    def handleDefault(self):
        """
        Private slot to set the selections as the new defaults.
        """
        Preferences.setVarFilters(self.getSelection())
        
