# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the search dialog for the helpviewer.
"""

from qt import *

from SearchForm import SearchForm

class SearchDialog(SearchForm):
    """
    Module implementing the search dialog for the helpviewer.
    """
    def __init__(self,browser,parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param browser text browser to search in (QTextBrowser)
        @param parent parent widget of this dialog (QWidget)
        @param name name of this dialog (string or QString)
        @param modal flag indicating a modal dialog (boolean)
        @param fl window flags
        """
        SearchForm.__init__(self,parent,name,modal,fl)
        
        self.browser = browser
        
        self.findHistory = QStringList()
        self.havefound = 0

    def enableFindButtons(self):
        """
        Private slot to enable/disable the find buttons.
        """
        if self.findtextCombo.currentText().isEmpty():
            self.findButton.setEnabled(0)
            self.findNextButton.setEnabled(0)
        else:
            self.findButton.setEnabled(1)

    def handleFind(self):
        """
        Private slot to find the entered text in the displayed page.
        """
        txt = self.findtextCombo.currentText()
        
        # This moves any previous occurence of this statement to the head
        # of the list and updates the combobox
        self.findHistory.remove(txt)
        self.findHistory.prepend(txt)
        self.findtextCombo.clear()
        self.findtextCombo.insertStringList(self.findHistory)
        
        if self.backwardsCheckBox.isChecked():
            lpara = self.browser.paragraphs()-1
            lind = self.browser.paragraphLength(lpara)-1
            ok, para, ind = self.browser.find(txt,
                            self.caseCheckBox.isChecked(),
                            self.wordCheckBox.isChecked(),
                            0, lpara, lind)
        else:
            ok, para, ind = self.browser.find(txt,
                            self.caseCheckBox.isChecked(),
                            self.wordCheckBox.isChecked(),
                            1, 0, 0)
        if ok:
            self.findNextButton.setEnabled(1)
            self.havefound = 1
        else:
            self.havefound = 0
            QMessageBox.information(self, self.caption(),
                self.trUtf8("'%1' was not found.").arg(txt))

    def handleFindNext(self):
        """
        Public slot to find the next occurance of text.
        """
        if not self.havefound:
            self.showFind()
            
        txt = self.findtextCombo.currentText()
        if self.backwardsCheckBox.isChecked():
            ok = self.browser.find(txt,
                            self.caseCheckBox.isChecked(),
                            self.wordCheckBox.isChecked(),
                            0)
        else:
            ok = self.browser.find(txt,
                            self.caseCheckBox.isChecked(),
                            self.wordCheckBox.isChecked(),
                            1)
        if not ok:
            self.havefound = 0
            QMessageBox.information(self, self.caption(),
                self.trUtf8("'%1' was not found.").arg(txt))

    def showFind(self):
        """
        Public method to display this dialog.
        """
        self.havefound = 0
        
        self.findtextCombo.clear()
        self.findtextCombo.insertStringList(self.findHistory)
        self.findtextCombo.setCurrentText('')
        
        self.caseCheckBox.setChecked(0)
        self.wordCheckBox.setChecked(0)
        self.backwardsCheckBox.setChecked(0)
        
        self.show()
