# -*- coding: utf-8 -*-

# Copyright (c) 2002, 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to show the found files to the user.
"""

from qt import *

from AddFoundFilesForm import AddFoundFilesForm

class AddFoundFilesDialog(AddFoundFilesForm):
    """
    Class implementing a dialog to show the found files to the user.
    
    The found files are displayed in a listview.
    Pressing the 'Add All' button adds all files to the current project,
    the 'Add Selected' button adds only the selected files and the 'Cancel'
    button cancels the operation.
    """
    
    def __init__(self,files,parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param files list of files, that have been found for addition (QStringList)
        @param parent parent widget of this dialog (QWidget)
        @param name name of this dialog (string or QString)
        @param modal flag to indicate a modal dialog (boolean)
        @param fl window flags
        """
        AddFoundFilesForm.__init__(self, parent, name, modal, fl)
        
        self.fileListBox.insertStringList(files)
        
        dummy = self.trUtf8('dummy')
        
    def handleAll(self):
        """
        Private slot to handle the 'Add All' button press. 
        
        @return always 1 (int)
        """
        self.done(1)
        
    def handleSelected(self):
        """
        Private slot to handle the 'Add Selected' button press.
        
        @return always 2 (int)
        """
        self.done(2)
        
    def isSelected(self, index):
        """
        Public method telling whether an item is selected in the listbox.
        
        @param index index of the item to check
        @return flag indicating the selection status of the item (boolean)
        """
        return self.fileListBox.isSelected(index)
        
    def getSelection(self):
        """
        Public method to return the selected items.
        
        @return list of selected files (QStringList)
        """
        list = QStringList()
        for i in range(self.fileListBox.count()):
            if self.fileListBox.isSelected(i):
                list.append(self.fileListBox.item(i).text())
        return list
