# -*- coding: utf-8 -*-

from qt import *
from LoadScriptForm import LoadScriptForm

"""
Module implementing a dialog for loading a script.
"""

class LoadScriptDialog(LoadScriptForm):
    """
    Class implementing a dialog for loading a script.
    """
    def __init__(self,parent = None,name = None,modal = 0,fl = 0):
        """
        Constructor
        
        @param parent -- parent of this dialog (QWidget)
        @param name -- name of this dialog (string or QString)
        @param modal -- flag indicating a modal window (boolean)
        @param fl -- window flags
        """
        LoadScriptForm.__init__(self,parent,name,modal,fl)

    def handleFileSelection(self):
        """
        Private slot to handle the script file selection.
        """
        file = QFileDialog.getOpenFileName(self.scriptFileEdit.text(),
            self.trUtf8("Script Files (*.py *.epy)"),
            self, None, self.trUtf8("Select script file"))
            
        if not file.isNull():
            self.scriptFileEdit.setText(QDir.convertSeparators(file))
        
    def getData(self):
        """
        Public method to retrieve the data entered into the dialog.
        
        @return tuple with the collected data (script name, script file,
            execute flag, delete flag) (string, string, boolean, boolean)
        """
        return (str(self.scriptNameEdit.text()), 
            str(self.scriptFileEdit.text()),
            self.executeCheckBox.isChecked(),
            self.deleteCheckBox.isChecked())
