# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing a dialog to enter the data for a merge operation.
"""

from qt import *

from MergeForm import MergeForm

class CvsMergeDialog(MergeForm):
    """
    Class implementing a dialog to enter the data for a merge operation.
    """
    def __init__(self, taglist, parent = None):
        """
        Constructor
        
        @param taglist list of previously entered tags (QStringList)
        @param parent parent widget (QWidget)
        """
        MergeForm.__init__(self, parent, None, 1)
       
        dummy = self.trUtf8('dummy')
        
        self.tag1Combo.clear()
        self.tag1Combo.insertStringList(taglist)
        self.tag2Combo.clear()
        self.tag2Combo.insertStringList(taglist)
        
        self.cvsTagValidator = QRegExpValidator(QRegExp(r"[a-zA-Z][a-zA-Z0-9_-]*"), self)
        self.tag1Combo.setValidator(self.cvsTagValidator)
        self.tag2Combo.setValidator(self.cvsTagValidator)
        
    def enableOkButton(self, text):
        """
        Private method used to enable/disable the OK-button.
        
        @param text ignored
        """
        self.okButton.setDisabled(text.isEmpty())
    
    def getParameters(self):
        """
        Public method to retrieve the tag data.
        
        @return tuple naming two tag names or two revisions (QString, QString)
        """
        return (self.tag1Combo.currentText(), self.tag2Combo.currentText())
