# -*- coding: utf-8 -*_

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing an authentication interface for Subversion.
"""

from qt import *

from AuthForm import svnAuthForm

class AuthDialog(svnAuthForm):
    """
    Class implementing an authentication interface for Subversion.
    """
    def __init__(self, parent=None, name=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        @param name name of this object (string or QString)
        """
        svnAuthForm.__init__(self, parent, name, 1)
        
        dummy = self.trUtf8('dummy')
        
    def getData(self):
        """
        Public method to retrieve the auth data.
        
        @return tuple of QString (username, password)
        """
        return (self.usernameEdit.text(),
            self.passwordEdit.text())
