# -*- coding: utf-8 -*-

# Copyright (c) 2003 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the file dialog wizard dialog.
"""

import os

from qt import *

from FileDialogWizardForm import FileDialogWizardForm

class FileDialogWizardDialog(FileDialogWizardForm):
    """
    Module implementing the color dialog wizard dialog.
    
    It displays a dialog for entering the parameters
    for the QFileDialog code generator.
    """
    def __init__(self, parent=None):
        """
        Constructor
        
        @param parent parent widget (QWidget)
        """
        FileDialogWizardForm.__init__(self, parent, None, 1)
        
        # to get around a quirk in PyQt if the subclass has no translatable strings
        dummy = self.trUtf8('Dummy')
        
    def testDlg(self):
        """
        Private method to test the selected options.
        """
        if self.rOpenFile.isOn():
            QFileDialog.getOpenFileName(\
                self.eStartWith.text(),
                self.eFilters.text(),
                None, None,
                self.eCaption.text(),
                None,
                self.cSymlinks.isOn())
        elif self.rOpenFiles.isOn():
            QFileDialog.getOpenFileNames(\
                self.eFilters.text(),
                self.eStartWith.text(),
                None, None,
                self.eCaption.text(),
                None,
                self.cSymlinks.isOn())
        elif self.rSaveFile.isOn():
            QFileDialog.getSaveFileName(\
                self.eStartWith.text(),
                self.eFilters.text(),
                None, None,
                self.eCaption.text(),
                None,
                self.cSymlinks.isOn())
        elif self.rDirectory.isOn():
            QFileDialog.getExistingDirectory(\
                self.eWorkDir.text(),
                None, None,
                self.eCaption.text(),
                self.cDirOnly.isOn(),
                self.cSymlinks.isOn())
        
    def getCode(self, indLevel, indString):
        """
        Public method to get the source code.
        
        @param indLevel indentation level (int)
        @param indString string used for indentation (space or tab) (string)
        @return generated code (string)
        """
        # calculate our indentation level and the indentation string
        il = indLevel + 1
        istring = il * indString
        
        # now generate the code
        code = 'QFileDialog.'
        if self.rOpenFile.isOn():
            code += 'getOpenFileName(\\%s%s' % (os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isOn():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (str(self.eStartWith.text()), os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (str(self.eFilters.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (str(self.eCaption.text()), os.linesep, istring)
            code += 'None, %d)%s' % (self.cSymlinks.isOn(), os.linesep)
        elif self.rOpenFiles.isOn():
            code += 'getOpenFileNames(\\%s%s' % (os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (str(self.eFilters.text()), os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isOn():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (str(self.eStartWith.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (str(self.eCaption.text()), os.linesep, istring)
            code += 'None, %d)%s' % (self.cSymlinks.isOn(), os.linesep)
        elif self.rSaveFile.isOn():
            code += 'getSaveFileName(\\%s%s' % (os.linesep, istring)
            if self.eStartWith.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                if self.cStartWith.isOn():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (str(self.eStartWith.text()), os.linesep, istring)
            if self.eFilters.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (str(self.eFilters.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (str(self.eCaption.text()), os.linesep, istring)
            code += 'None, %d)%s' % (self.cSymlinks.isOn(), os.linesep)
        elif self.rDirectory.isOn():
            code += 'getExistingDirectory(\\%s%s' % (os.linesep, istring)
            if self.eWorkDir.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                if self.cWorkDir.isOn():
                    fmt = '%s,%s%s'
                else:
                    fmt = 'self.trUtf8("%s"),%s%s'
                code += fmt % (str(self.eWorkDir.text()), os.linesep, istring)
            code += 'None, None,%s%s' % (os.linesep, istring)
            if self.eCaption.text().isEmpty():
                code += 'None,%s%s' % (os.linesep, istring)
            else:
                code += 'self.trUtf8("%s"),%s%s' % \
                    (str(self.eCaption.text()), os.linesep, istring)
            code += '%d, %d)%s' % \
                (self.cDirOnly.isOn(), self.cSymlinks.isOn(), os.linesep)
            
        return code
