# -*- coding: utf-8 -*-

# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>
#
# This is the uninstall script for eric3.

import sys
import os
import string
import shutil
import distutils.sysconfig

# Define the globals.
progName = None
modDir = None
platBinDir = None

def usage(rcode = 2):
    """Display a usage message and exit.

    rcode is the return code passed back to the calling process.
    """
    global progName, platBinDir, modDir, distDir

    print "Usage:"
    print "    %s [-h] [-b dir] [-d dir] [-i dir]" % (progName)
    print "where:"
    print "    -h             display this help message"
    print "    -b dir         where eric3, qtunittest and helpviewer have been installed [default %s]" % (platBinDir)
    print "    -d dir         where eric3 python files have been installed [default %s]" % (modDir)

    sys.exit(rcode)


def initGlobals():
    """Sets the values of globals that need more than a simple assignment.
    """
    global platBinDir, modDir

    if sys.platform == "win32":
        platBinDir = sys.exec_prefix
    else:
        platBinDir = "/usr/local/bin"

    modDir = distutils.sysconfig.get_python_lib()


def wrapperName(dname,wfile):
    """Create the platform specific name for the wrapper script.
    """
    if sys.platform == "win32":
        wname = dname + "\\" + wfile + ".bat"
    else:
        wname = dname + "/" + wfile

    return wname


def uninstallEric():
    """Create the python wrapper files for eric3, qtunittest and helpviewer
    and install all the necessary files comprising the package.
    """
    global modDir, platBinDir
    
    ericdir = os.path.join(modDir, "eric3")
    
    # Create the platform specific wrapper names.
    ename = wrapperName(platBinDir,"eric3")
    uname = wrapperName(platBinDir,"eric3-unittest")
    hname = wrapperName(platBinDir,"eric3-helpviewer")
    dname = wrapperName(platBinDir,"eric3-doc")
    qname = wrapperName(platBinDir,"eric3-qregexp")
    rname = wrapperName(platBinDir,"eric3-re")
    ouname = wrapperName(platBinDir,"qtunittest")
    ohname = wrapperName(platBinDir,"helpviewer")
    
    # Remove the wrapper scripts
    if os.path.exists(ename):
        os.remove(ename)
    if os.path.exists(uname):
        os.remove(uname)
    if os.path.exists(hname):
        os.remove(hname)
    if os.path.exists(dname):
        os.remove(dname)
    if os.path.exists(qname):
        os.remove(qname)
    if os.path.exists(rname):
        os.remove(rname)
    if os.path.exists(ouname):
        os.remove(ouname)
    if os.path.exists(ohname):
        os.remove(ohname)
    
    # Cleanup the install directory
    try:
        shutil.rmtree(ericdir, 1)
    except:
        pass
    
    
def main(argv):
    """The main function of the script.

    argv is the list of command line arguments.
    """
    import getopt

    # Parse the command line.
    global progName
    progName = os.path.basename(argv[0])

    initGlobals()

    try:
        optlist, args = getopt.getopt(argv[1:],"hb:d:")
    except getopt.GetoptError:
        usage()

    global platBinDir

    for opt, arg in optlist:
        if opt == "-h":
            usage(0)
        elif opt == "-b":
            platBinDir = arg
        elif opt == "-d":
            global modDir
            modDir = arg
    
    uninstallEric()
    
    
if __name__ == "__main__":
    try:
        main(sys.argv)
    except SystemExit:
        raise
    except:
        print \
"""An internal error occured.  Please report all the output of the program,
including the following traceback, to eric-bugs@die-offenbachs.de.
"""
        raise
