#ifndef _ERL_DEBUG_H_
#define _ERL_DEBUG_H_

#ifdef DEBUG

#ifdef HIPE
#include "hipe_debug.h"
#endif

/* Heap areas will be filled with this value when they are deallocated
 * after a garbage collection. This value used to be 0xff, but that is
 * an immediate and might not crash the system if it is encountered.
 * The value is now 0x01, the cons of death.
 */
#define DEBUG_BAD_BYTE 0x01
#define DEBUG_BAD_WORD 0x01010101

/*
 * VERBOSE. Use the -v option to enable the different categories.
 */
#define VERBOSE(flag, format) (flag & verbose ? erts_printf format : 0)

#define DEBUG_DEFAULT      0x0000    /* No flags are set per default         */
#define DEBUG_SYSTEM       0x0001    /* Misc system info at startup and end  */
#define DEBUG_PRIVATE_GC   0x0002    /* GC of private heaps                  */
#define DEBUG_HYBRID_GC    0x0004    /* GC of the message area               */
#define DEBUG_ALLOCATION   0x0008    /* HAlloc. To find holes in the heap    */
#define DEBUG_MESSAGES     0x0010    /* Message passing                      */
#define DEBUG_THREADS      0x0020    /* Thread-related stuff                 */
#define DEBUG_PROCESSES    0x0040    /* Process creation and removal         */
#define DEBUG_MEMORY       0x0080    /* Display results of memory checks     */

extern Uint32 verbose;

void upp(byte*, int);
void pat(Eterm);
void pinfo(void);
void pp(Process*);
void ppi(Eterm);
void pba(Process*, int);
void td(Eterm);
void ps(Process*, Eterm*);

#else /* Non-debug mode */

#define VERBOSE(flag,format)

#endif /* DEBUG */

/*
 * These functions can be handy when developing, and perhaps useful
 * even outside debugging.
 */
extern void erts_check_stack(Process *p);
extern void erts_check_heap(Process *p);
extern void erts_check_memory(Process *p, Eterm *start, Eterm *end);
extern void verify_process(Process *p);
extern void verify_everything(void);
extern void print_tagged_memory(Eterm *start, Eterm *end);
extern void print_untagged_memory(Eterm *start, Eterm *end);
extern void print_memory(Process *p);
extern void print_memory_info(Process *p);

#ifdef HYBRID
extern void print_ma_info(void);
extern void print_message_area(void);
extern void check_message_area(void);
#endif

#endif /* _ERL_DEBUG_H_ */
