\name{MLoef}
\alias{MLoef}
\alias{print.MLoef}
\alias{summary.MLoef}
\title{Computation of Martin-Lf's LR-Test}
\description{This LR-Test is based on item subgroup splitting.}
\usage{
MLoef(robj, splitcr = "median")
}
\arguments{
  \item{robj}{Object of class \code{Rm}.}
  \item{splitcr}{Split criterion to define two groups of item.
    \code{"median"} and \code{"mean"} split items in two groups based on their
    items' raw scores. \code{splitcr} can also be a vector of length k (where k
    denotes the number of items) that takes two distinct values to define groups
    used for the Martin-Lf Test.}
}
\details{The function currently does not allow for missing values.
         %The function can handle missing values, as long as every subject has at
         %least 2 valid responses in each group of items.

  If the split criterion is \code{"median"} or \code{"mean"} and one or more items'
  raw scores are equal the median resp. mean, \code{MLoef} will issue a warning
  that those items are assigned to the lower raw score group. \code{summary.MLoef}
  gives detailed information about the allocation of all items.

  \code{summary} and \code{print} methods are available for objects of class
  \code{MLoef}.
}
\value{
  \code{MLoef} returns an object of class \code{MLoef} containing:
    \item{X01}{binary data matrix of \code{robj}}
    \item{model}{model of \code{robj}}
    \item{LR}{LR-value}
    \item{df}{degrees of freedom of the test statistic}
    \item{p.value}{p-value of the test}
    \item{L0}{log-likelihood of the Rasch model}
    \item{L1}{log-likelihood of group 1}
    \item{L2}{log-likelihood of group 2}
    \item{theta.table.RM}{vector of persons' raw scores of the Rasch model}
    \item{theta.table.MLoef}{tabulation of persons' raw scores in the two groups}
    \item{items1}{list of items in group 1}
    \item{items2}{list of items in group 2}
    \item{k}{number of items in groups 1 and 2}
    \item{splitcr}{submitted split criterion}
    \item{split.vector}{binary allocation of items to groups}
    \item{warning}{items equalling median or mean for the respective split criteria}
    \item{call}{the matched call}
}
\references{
Fischer, G. H., and Molenaar, I. (1995). Rasch Models -- Foundations, Recent Developements, and Applications. Springer.

Rost, J. (2004). Lehrbuch Testtheorie -- Testkonstruktion. Bern: Huber.
}
\author{Marco Maier, Reinhold Hatzinger}
%\note{}
\seealso{\code{\link{LRtest}}, \code{\link{Waldtest}}}
\examples{
# Martin-Loef-test on dichotomous Rasch model using "median"
# and a user-defined split
splitvec <- c(1, 1, 1, 1, 0, 1, 0, 0, 1, 0)

res <- RM(raschdat1[,1:10])

MLoef.1 <- MLoef(res, splitcr = "median")
MLoef.2 <- MLoef(res, splitcr = splitvec)

MLoef.1

summary(MLoef.2)
}
\keyword{models}
