/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include "Parallel/BMesh2D_cmd.h"
#include "Parallel/sublattice_cmd.h"
 
BondedMesh2DIGCommand::BondedMesh2DIGCommand(const MpiRankAndComm& globalRankAndComm) 
  : BroadcastCommand(globalRankAndComm, CMD_ADDBONDEDMESH2DIG)
{}
  
void BondedMesh2DIGCommand::appendMesh2DParam(const BMesh2DIP &MeshPrms)
{
  append(MeshPrms.getName().c_str());
  append(MeshPrms.getMeshName().c_str());
  append(MeshPrms.k);
  append(MeshPrms.brk);
}
  
void BondedMesh2DIGCommand::appendGapBuildPrms(const MeshGapBuildPrms &buildPrms)
{
  append(buildPrms.getTypeString().c_str());
  append(buildPrms.m_maxGap);
}

void BondedMesh2DIGCommand::appendTagBuildPrms(const MeshTagBuildPrms &buildPrms)
{
  append(buildPrms.getTypeString().c_str());
  append(buildPrms.m_tag);
  append(buildPrms.m_mask);
}
