#############################################################
##                                                         ##
## Copyright (c) 2003-2013 by The University of Queensland ##
## Earth Systems Science Computational Centre (ESSCC)      ##
## http://www.uq.edu.au/esscc                              ##
##                                                         ##
## Primary Business: Brisbane, Queensland, Australia       ##
## Licensed under the Open Software License version 3.0    ##
## http://www.opensource.org/licenses/osl-3.0.php          ##
##                                                         ##
#############################################################

from esys.lsm.vis import core
from sphere       import Sphere

class SphereExtractor(core.SphereExtractor):
    def __init__(
        self,
        radiusMap   = lambda dataRecord: dataRecord.getRadius(),
        centerMap   = lambda dataRecord: dataRecord.getCenter(),
        modifierMap = lambda dataRecord: None,
        radiusScale = 1.0
    ):
        core.SphereExtractor.__init__(
            self,
            radiusMap,
            centerMap,
            modifierMap,
            radiusScale
        )

    def addActor(self, record, addTo):
        """
        Adds the sphere-actor associated with the data in
        C{record} to C{addTo}.
        """
        glyph = \
            Sphere(
                center=self.getCenter(record),
                radius=self.getRadius(record)
            )
        glyph.apply(self.getModifier(record))
        glyph.addActor(addTo)

