#include <ethos/ethos.h>
#include <ethos/ethos-ui.h>
#include "sample.h"

static GtkWidget *window = NULL;
static GtkWidget *vbox   = NULL;

GtkWidget*
sample_get_window (void)
{
	return window;
}

void
sample_add_widget (GtkWidget *widget)
{
	gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, TRUE, 0);
}

void
sample_remove_widget (GtkWidget *widget)
{
	gtk_container_remove (GTK_CONTAINER (vbox), widget);
}

gint
main (gint   argc,
      gchar *argv[])
{
	EthosManager *manager;
	gchar        *plugin_dirs[2] = { "plugins", NULL };
	GtkWidget    *manager_widget;

	gtk_init (&argc, &argv);

	/* create ui for plugins to attach to */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size (GTK_WINDOW (window), 640, 480);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
	gtk_container_set_border_width (GTK_CONTAINER (window), 12);
	g_signal_connect (window, "delete-event", gtk_main_quit, NULL);
	gtk_widget_show (window);

	vbox = gtk_vbox_new (FALSE, 6);
	gtk_widget_set_name (vbox, "vbox");
	gtk_container_add (GTK_CONTAINER (window), vbox);
	gtk_widget_show (vbox);

	/* setup ethos */
	manager = ethos_manager_new ();
	ethos_manager_set_app_name (manager, "Sample");
	ethos_manager_set_plugin_dirs (manager, (gchar**)plugin_dirs);
	manager_widget = ethos_ui_manager_widget_new ();
	ethos_ui_manager_widget_set_manager (ETHOS_UI_MANAGER_WIDGET (manager_widget), manager);
	gtk_box_pack_start (GTK_BOX (vbox), manager_widget, TRUE, TRUE, 0);
	gtk_widget_show (manager_widget);

	ethos_manager_initialize (manager);
	gtk_main ();

	return 0;
}
