/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-cfg-edit-common.h,v 1.7 2004/12/17 10:20:51 hoa Exp $
 */

#ifndef ETPAN_CFG_EDIT_COMMON_H

#include "etpan-subapp-types.h"
#include "etpan-input-common-types.h"
#include <sys/types.h>
#include <libetpan/libetpan.h>
#include <time.h>
#include "etpan-filename-input-types.h"

int etpan_cfg_edit_string(struct etpan_subapp * app, char * prompt,
    char * string, size_t size, int flags);

int etpan_cfg_edit_filename_with_type(struct etpan_subapp * app,
    char * prompt, char * string, size_t size, int type);

int etpan_cfg_edit_filename(struct etpan_subapp * app, char * prompt,
    char * string, size_t size);

int etpan_cfg_edit_int(struct etpan_subapp * app, char * prompt,
    int * value);

int etpan_cfg_edit_addr(struct etpan_subapp * app, char * prompt,
    struct mailimf_address_list ** value);

int etpan_cfg_edit_newsgroup(struct etpan_subapp * app,
    struct mailstorage * storage,
    char * prompt,
    char * string, size_t size);

int etpan_cfg_edit_imap_mailbox(struct etpan_subapp * app,
    struct mailstorage * storage,
    char * prompt,
    char * string, size_t size);

int etpan_cfg_edit_time(struct etpan_subapp * app, char * prompt,
    time_t * value);

#endif
