#ifndef ETPAN_CFG_SENDER_H

#define ETPAN_CFG_SENDER_H

#include "etpan-cfg-sender-types.h"
#include "etpan-app-types.h"

int etpan_sender_config_read(char * filename,
    struct etpan_sender_config ** pconfig);

void etpan_sender_config_free(struct etpan_sender_config * config);

struct etpan_sender_config * etpan_sender_config_new(void);

struct etpan_sender_item * etpan_sender_item_new(char * name,
    int type, char * command, char * host, int port,
    char * login, char * password);

void etpan_sender_item_free(struct etpan_sender_item * item);

int etpan_sender_config_add_item(struct etpan_sender_config * config,
    struct etpan_sender_item * item);

void etpan_sender_config_remove_item(struct etpan_sender_config * config,
    char * name);

struct etpan_sender_item *
etpan_sender_config_get_item(struct etpan_sender_config * config);

void etpan_sender_config_set_item(struct etpan_sender_config * config,
    char * name);

#endif
