/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-cfg-vfolder-types.h,v 1.9 2004/03/18 01:32:02 hoa Exp $
 */

#ifndef ETPAN_CFG_VFOLDER_TYPES_H

#define ETPAN_CFG_VFOLDER_TYPES_H

#include <libetpan/libetpan.h>
#include <libetpan/clist.h>
#include <libetpan/chash.h>
#include "etpan-cfg-account.h"

struct etpan_vfolder_property {
  struct etpan_account_info * account;
  struct mailfolder * sent_folder;
  struct mailfolder * draft_folder;
  int poll;
  uint32_t max;
  struct mailimf_address_list * mail_to;

   /* do auto build child list */
  int auto_build;
  /* if auto_build is 1, child will be automatically
     retrieved, depending on the storage */
  /* IMAP, mbox, MH, Maildir, NNTP (unable to do this for POP3) */
  int auto_build_type;
  
  /* for IMAP, POP3 (for POP3, this will generate only one folder) */
  struct mailstorage * build_storage;
  
  /* for MH, Maildir, mbox, NNTP (newsrc file),
     this will add automatically created storages */
  char * build_path;
  
  /* if it was built automatically, to find which folder it
     has been generated from, you have to look for parent until
     you find one that was not generated */
  int generated;
};

struct etpan_vfolder_config {
  struct mailfolder * root;
  chash * folder_prop;
  struct mailfolder * default_folder;
  struct mailfolder * sent_folder;
  struct mailfolder * draft_folder;
};

struct etpan_offline_config {
  chash * folder_hash;
  clist * folder_list;
};

#endif
