/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-msg-new.h,v 1.9 2004/12/12 12:38:57 hoa Exp $
 */

#ifndef ETPAN_MSG_NEW_H

#define ETPAN_MSG_NEW_H

#include "etpan-app-types.h"
#include "etpan-subapp-types.h"
#include "etpan-msg-new-types.h"
#include <libetpan/libetpan.h>

void etpan_message_mime_remove(struct mailmime * mime);

void etpan_message_mime_clear(struct mailmime * mime);

/* message new */

int etpan_message_new(struct etpan_subapp * app,
    struct mailfolder * folder, struct mailmime ** result,
    struct mailmime ** pedit_part);

int etpan_compose_new(struct etpan_subapp * app, struct mailfolder * folder);

int etpan_edit_file(struct etpan_app * app,
    char * filename, int line, size_t * size);

struct mailmime * etpan_message_get_first_text_part(struct mailmime * mime);

int etpan_add_signature(FILE * f, struct etpan_account_info * account);

int etpan_compose(struct etpan_subapp * app,
    struct mailfolder * post_from_folder,
    struct mailmime * mime,
    struct mailmime * edit_part,
    int edit_part_line,
    void (* action)(void *), void * arg,
    void (* cancel_action)(void *));

int etpan_build_simple_mime(struct etpan_app * app,
    struct mailimf_fields * new_fields,
    char * body_filename,
    struct mailmime ** result,
    struct mailmime ** pedit_part);

int etpan_new_get_fields(struct etpan_app * app,
    struct mailfolder * folder,
    struct mailimf_address_list * dest_addr,
    struct mailimf_fields ** result);

int etpan_set_text_content_type(struct etpan_app * app,
    struct mailmime * mime);

int etpan_message_send(struct etpan_subapp * app,
    struct mailfolder * post_from_folder,
    struct mailimf_fields * fields, char * filename);

int etpan_message_mime_send(struct etpan_subapp * app,
    struct mailfolder * post_from_folder,
    struct mailmime * mime);

int etpan_get_send_type(struct mailimf_fields * new_fields,
    struct mailfolder * post_from_folder);

int etpan_new_get_resent_fields(struct etpan_app * app,
    struct mailfolder * folder,
    struct mailimf_address_list * dest_addr,
    struct mailimf_fields ** result);

#endif
