/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-viewer-common-types.h,v 1.6 2003/12/15 16:08:54 hoa Exp $
 */

#ifndef ETPAN_VIEWER_COMMON_TYPES_H

#define ETPAN_VIEWER_COMMON_TYPES_H

#include <libetpan/carray.h>
#include <stdio.h>
#include <sys/types.h>

#define ETPAN_VIEWER_FREE_FLAGS_FREE     1
#define ETPAN_VIEWER_FREE_FLAGS_UNMAP    2
#define ETPAN_VIEWER_FREE_FLAGS_MMAPFREE 4
#define ETPAN_VIEWER_FREE_FLAGS_REMOVE   8
#define ETPAN_VIEWER_FREE_FLAGS_CLOSE    16

struct etpan_viewer_common_app_state {
  /* colors */
  int viewer_normal_attr;
  int viewer_header_attr;
  int viewer_signature_attr;
  int viewer_link_attr;
  int viewer_description_attr;
  int viewer_security_attr;
  int viewer_error_attr;
  int main_attr;
  int chosen_header_attr;
  int header_attr;
  int selection_attr;
  int status_attr;
  
  /* text to view */
  char * text;
  size_t size;
  carray * attr;
  char * filename;
  FILE * f;
  /* on close */
  int free_flags;
  
  /* cursor */
  unsigned int count;
  unsigned int chosen;
  unsigned int col;
  unsigned int left;
  unsigned int line;
  unsigned int top;
  size_t current_offset;

  /* options */
  int rot13_enabled;
  int cursor;
};

#endif
