/*
 *	Euler - a numerical lab
 *
 *	platform : gtk / X11
 *
 *	file : colbu.h -- color button widget
 */

#ifndef _COLBUT_H_
#define _COLBUT_H_

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define TYPE_COL_BUT            (col_but_get_type ())
#define COL_BUT(obj)            (GTK_CHECK_CAST((obj), TYPE_COL_BUT, ColBut))
#define COL_BUT_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), TYPE_COL_BUT, ColButClass))
#define IS_COL_BUT(obj)         (GTK_CHECK_TYPE((obj), TYPE_COL_BUT))
#define IS_COL_BUT_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), TYPE_COL_BUT))

typedef struct _ColBut      ColBut;
typedef struct _ColButClass ColButClass;


struct _ColBut
{
	GtkButton	button;

	gushort		color[3];
	gdouble		fcolor[3];
	GtkWidget *	cbox;
	GtkWidget *	dialog;
};

struct _ColButClass
{
	GtkButtonClass parent_class;

	void (*color_changed)(ColBut *cb);
};

GtkType    col_but_get_type(void);
GtkWidget* col_but_new(gint width, gint height, gushort r, gushort g, gushort b);
void       col_but_get_color(GtkWidget *widget, gushort color[3]);
void       col_but_set_color(GtkWidget *widget, gushort r, gushort g, gushort b);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __WIDGET_CB_H__ */
