
#ifndef __RSS_H_
#define __RSS_H_

#define PLUGIN_INSTALL_DIR @PLUGIN_INSTALL_DIR@

GConfClient *rss_gconf;

typedef struct _RDF {
        char 		*uri;
        char 		*html;
        xmlDocPtr 	cache;
        gboolean 	shown;
        gchar 		*type;    //char type
        guint 		type_id;  //num type
        u_int32_t	feedid;  //crc32 id of feed
        /* Soup stuff */
        SoupMessage *message;
} RDF;

typedef struct _rssfeed {
        GHashTable      *hr;            	//feeds hash
        GHashTable      *hn;            	//feeds hash
        GHashTable      *hre;   		//enabled feeds hash
        GHashTable      *hrt;   		//feeds name hash
        GHashTable      *hrh;   		//fetch html flag
        GHashTable      *hrid;   		//fetch html feed identifier
        GHashTable      *hruser;   		//fetch html feed identifier
        GHashTable      *hrpass;   		//fetch html feed identifier
        GtkWidget       *feed_dialog;
        GtkWidget       *progress_dialog;
        GtkWidget       *progress_bar;
        GtkWidget       *label;
        GtkWidget       *sr_feed;		//s&r upper text (feed)
        GtkWidget       *treeview;
        GtkWidget       *edbutton;
	GtkWidget	*errdialog;
	gchar		*err;			//if using soup _unblocking error goes here
	gchar		*err_feed;		//name of the feed that caused above err
        gchar           *cfeed; 		//current feed name
#ifdef EVOLUTION_2_12
	EMEventTargetSendReceive *t;
#else
        EMPopupTargetSelect *t;
#endif
        gboolean        setup;
        gboolean        pending;
	guint		feed_queue;
        gboolean        cancel; 		//cancelation signal
        GHashTable      *session;		//queue of active unblocking sessions
        SoupSession     *b_session;		//active blocking session
	guint		rc_id;
	struct _send_info *info;		//s&r data
	struct userpass	*un;
	guint		cur_format;
	guint		chg_format;
} rssfeed;

#define GCONF_KEY_START_CHECK "/apps/evolution/evolution-rss/startup_check"
#define GCONF_KEY_REP_CHECK "/apps/evolution/evolution-rss/rep_check"
#define GCONF_KEY_REP_CHECK_TIMEOUT "/apps/evolution/evolution-rss/rep_check_timeout"
#define GCONF_KEY_USE_PROXY "/apps/evolution/evolution-rss/use_proxy"
#define GCONF_KEY_HOST_PROXY "/apps/evolution/evolution-rss/host_proxy"
#define GCONF_KEY_PORT_PROXY "/apps/evolution/evolution-rss/port_proxy"
#define GCONF_KEY_AUTH_PROXY "/apps/evolution/evolution-rss/auth_proxy"
#define GCONF_KEY_USER_PROXY "/apps/evolution/evolution-rss/user_proxy"
#define GCONF_KEY_PASS_PROXY "/apps/evolution/evolution-rss/pass_proxy"

enum {
	RSS_FEED,
	RDF_FEED,
	ATOM_FEED
};

typedef struct ADD_FEED {
	GtkWidget	*dialog;
        gchar           *feed_url;
        gboolean        fetch_html;	//show webpage instead of summary
        gboolean        add;		//ok button
	gboolean	changed;
} add_feed;

typedef struct USERPASS {
	gchar *username;
	gchar *password;
} userpass;

typedef struct _setupfeed {
	GladeXML  *gui;
	GtkWidget *treeview;
	GtkWidget *add_feed;
	GtkWidget *check1;
	GtkWidget *check2;
	GtkWidget *check3;
	GtkWidget *spin;
	GtkWidget *use_proxy;
	GtkWidget *host_proxy;
	GtkWidget *port_proxy;
	GtkWidget *proxy_details;
	GtkWidget *details;
} setupfeed;

struct _send_data {
        GList *infos;

        GtkDialog *gd;
        int cancelled;

        CamelFolder *inbox;     /* since we're never asked to update this one, do it ourselves */
        time_t inbox_update;

        GMutex *lock;
        GHashTable *folders;

        GHashTable *active;     /* send_info's by uri */
};

typedef enum {
        SEND_RECEIVE,           /* receiver */
        SEND_SEND,              /* sender */
        SEND_UPDATE,            /* imap-like 'just update folder info' */
        SEND_INVALID
} send_info_t ;

typedef enum {
        SEND_ACTIVE,
        SEND_CANCELLED,
        SEND_COMPLETE
} send_state_t;

struct _send_info {
        send_info_t type;               /* 0 = fetch, 1 = send */
        CamelOperation *cancel;
        char *uri;
        int keep;
        send_state_t state;
        GtkWidget *progress_bar;
        GtkWidget *cancel_button;
        GtkWidget *status_label;

        int again;              /* need to run send again */

        int timeout_id;
        char *what;
        int pc;

        /*time_t update;*/
        struct _send_data *data;
};

u_int32_t gen_crc(const char *msg);
void create_user_pass_dialog(gchar *url);

#endif
