#
# Physical attribute GUI editor for EWB ver.3.3
# Core file
# (c)1999-2002 ҥ
#

# ʪ°󥦥ɥ
proc makephylist {filename} {
	global rootwd rootht
	global triger tcount
	global afname aphyname atype aincfile asize acaploc aloc aattrib aparcent acount acaption
	global acappt acapaki acapunit asoroe alaki araki alunit arunit
	global axsize aysize axunit ayunit
	global type incfile xsize ysize xunit yunit parcent loc laki raki lunit runit soroe caploc capaki capunit
	global wflag answer

	set phywin [string tolower [string range $filename 0 [expr [string first "." $filename] - 1]]]
	global $phywin

	if {[winfo exists .$phywin]} {} else {
		toplevel .$phywin
		wm geometry .$phywin 730x427+[expr $rootwd / 2 - 400]+[expr $rootht /2 - 300]
		frame .$phywin.list
		frame .$phywin.command

		label .$phywin.lb0 -text "ƥե: $filename"
		button .$phywin.save -text "¸" -command {
			writephy
			set wflag 1
		}
		button .$phywin.close -text "Ĥ" -command {
			set phywin [string range [focus -displayof .] 1 end]
			if {$wflag} {} else {
				ynmsg "ɽ¸ޤ"
				if {$answer} {
					writephy
					set wflag 1
				}
			}
			destroy .$phywin
		}
		listbox .$phywin.l0 -height 20 -width 100 -xscrollcommand ".$phywin.s2 set" -yscrollcommand ".$phywin.s1 set" -selectmode extended 
		scrollbar .$phywin.s1 -orient vertical -command ".$phywin.l0 yview"
		scrollbar .$phywin.s2 -orient horizontal -command ".$phywin.l0 xview"

		label .$phywin.triger -text "ȥꥬ̾"

		button .$phywin.file -text "ե̾" -padx 16 -command {
			set phywin [string range [focus -displayof .] 1 end]
			set selection [.$phywin.l0 curselection]
			if {[llength [.$phywin.l0 curselection]] > 0} {
				if {[llength [.$phywin.l0 curselection]] > 1} {
					errormsg "٤ʣΥե̾Ǥޤ"
				} else {
					set num [set ${phywin}([.$phywin.l0 curselection])]
					set type $atype($num)
					selectfile $aincfile($num)
					if {[string compare $type ""]} {
						if {[string compare $atype($num) "-"]} {} else {
							set axsize($num) 0
							set aysize($num) 0
							set axunit($num) "mm"
							set ayunit($num) "mm"
							set aparcent($num) 0
							set aloc($num) "htb"
							set aattrib($num) "-"
							set acappt($num) "cs"
							set acapaki($num) "-"
							set acapunit($num) "mm"
							set asoroe($num) "C"
							set alaki($num) 0
							set alunit($num) "mm"
							set araki($num) 0
							set arunit($num) "mm"
							set axsize($num) 0
							set aysize($num) 0
							set axunit($num) "mm"
							set ayunit($num) "mm"
						}
						set atype($num) $type
						set aincfile($num) $incfile
						makephylist $afname($num)
						set wflag 0
					}
				}
				.$phywin.l0 selection clear 0 end
				foreach i $selection {
					.$phywin.l0 selection set $i
				}
			}
		}
		button .$phywin.size -text "ǥ" -padx 11 -command {
			set phywin [string range [focus -displayof .] 1 end]
			set selection [.$phywin.l0 curselection]
			if {[llength [.$phywin.l0 curselection]] > 0} {
				for {set i 0} {$i < [llength $selection]} {incr i} {
					set num [set ${phywin}([lindex $selection $i])]
					if {[string compare $atype($num) "i"] && [string compare $atype($num) "-"]} {
						break
					}
				}
				if {$i == [llength $selection]} {
					errormsg "ǥλEPSޤϥӤˤΤͭǤ"
				} else {
					if {[llength $selection] > 1} {
						set xsize 0
						set ysize 0
						set xunit "mm"
						set yunit "mm"
						set parcent 0
					} else {
						set xsize $axsize([set ${phywin}($selection)])
						set ysize $aysize([set ${phywin}($selection)])
						set xunit $axunit([set ${phywin}($selection)])
						set yunit $ayunit([set ${phywin}($selection)])
						set parcent $aparcent([set ${phywin}($selection)])
					}
					setsize
					if {[string compare $parcent ""]} {
						foreach i $selection {
							set num [set ${phywin}($i)]
							switch $atype($num) {
								"l" {
									if {[string compare $parcent "-"]} {
										if {$parcent == 0} {
											set axsize($num) $xsize
											set aysize($num) $ysize
											set axunit($num) $xunit
											set ayunit($num) $yunit
											set aparcent($num) 0
										}
									} else {
										set axsize($num) $xsize
										set aysize($num) $ysize
										set axunit($num) $xunit
										set ayunit($num) $yunit
										set aparcent($num) 0
									}
								}
								"e" {
									set axsize($num) $xsize
									set aysize($num) $ysize
									set axunit($num) $xunit
									set ayunit($num) $yunit
									if {[string compare $parcent "-"]} {
										set aparcent($num) $parcent
									} else {
										set aparcent($num) 0
									}
								}
								default {}
							}
						}
						makephylist $afname([set ${phywin}(0)])
						set wflag 0
					}
					.$phywin.l0 selection clear 0 end
					foreach i $selection {
						.$phywin.l0 selection set $i
					}
				}
			}
		}
		button .$phywin.caploc -text "װ" -padx 4 -command {
			set phywin [string range [focus -displayof .] 1 end]
			set selection [.$phywin.l0 curselection]
			if {[llength [.$phywin.l0 curselection]] > 0} {
				if {[llength $selection] > 1} {
					set cappt "cs"
					set capaki "-"
					set capunit "mm"
				} else {
					set cappt $acappt([set ${phywin}($selection)])
					set capaki $acapaki([set ${phywin}($selection)])
					set capunit $acapunit([set ${phywin}($selection)])
				}
				setcaploc
				if {[string compare $cappt ""]} {
					foreach i $selection {
						set num [set ${phywin}($i)]
						if {[string compare $atype($num) "-"]} {
							if {[string compare $atype($num) "i"] || \
							([string compare $cappt "nw"] && \
							[string compare $cappt "w"] && \
							[string compare $cappt "sw"] && \
							[string compare $cappt "ne"] && \
							[string compare $cappt "e"] && \
							[string compare $cappt "se"])} {
								set acappt($num) $cappt
								set acapaki($num) $capaki
								set acapunit($num) $capunit
							}
						}
					}
					makephylist $afname([set ${phywin}(0)])
					set wflag 0
					.$phywin.l0 selection clear 0 end
					foreach i $selection {
						.$phywin.l0 selection set $i
					}
				}
			}
		}
		button .$phywin.loc -text "" -padx 5 -command {
			set phywin [string range [focus -displayof .] 1 end]
			set selection [.$phywin.l0 curselection]
			if {[llength [.$phywin.l0 curselection]] > 0} {
				if {[llength $selection] > 1} {
					set loc "htb"
				} else {
					set loc $aloc([set ${phywin}($selection)])
				}
				setloc2
				if {[string compare $loc "-"]} {
					foreach i $selection {
						set num [set ${phywin}($i)]
						if {[string compare $atype($num) "-"]} {
							set aloc($num) $loc
						}
					}
					makephylist $afname([set ${phywin}(0)])
					set wflag 0
					.$phywin.l0 selection clear 0 end
					foreach i $selection {
						.$phywin.l0 selection set $i
					}
				}
			}
		}
		button .$phywin.attrib -text "·/" -padx 6 -command {
			set phywin [string range [focus -displayof .] 1 end]
			set selection [.$phywin.l0 curselection]
			if {[llength [.$phywin.l0 curselection]] > 0} {
				if {[llength $selection] > 1} {
					set soroe "L"
					set laki 0
					set raki 0
					set lunit "mm"
					set runit "mm"
				} else {
					set soroe $asoroe([set ${phywin}($selection)])
					set laki $alaki([set ${phywin}($selection)])
					set raki $araki([set ${phywin}($selection)])
					set lunit $alunit([set ${phywin}($selection)])
					set runit $arunit([set ${phywin}($selection)])
				}
				setaki
				if {[string compare $soroe ""]} {
					foreach i $selection {
						set num [set ${phywin}($i)]
						if {[string compare $atype($num) "-"]} {
							set asoroe($num) $soroe
							set alaki($num) $laki
							set araki($num) $raki
							set alunit($num) $lunit
							set arunit($num) $runit
						}
					}
					makephylist $afname([set ${phywin}(0)])
					set wflag 0
					.$phywin.l0 selection clear 0 end
					foreach i $selection {
						.$phywin.l0 selection set $i
					}
				}
			}
		}
		label .$phywin.caption -text "ץ"

		grid .$phywin.l0 -in .$phywin.list -row 2 -column 0 -sticky nsew
		grid .$phywin.s1 -in .$phywin.list -row 2 -column 1 -sticky nsw
		grid .$phywin.s2 -in .$phywin.list -row 3 -column 0 -sticky new
		place .$phywin.triger -x 0 -y 5 -in .$phywin.command
		place .$phywin.file -x 80 -y 0 -in .$phywin.command
		place .$phywin.size -x 190 -y 0 -in .$phywin.command
		place .$phywin.caploc -x 290 -y 0 -in .$phywin.command
		place .$phywin.loc -x 375 -y 0 -in .$phywin.command
		place .$phywin.attrib -x 420 -y 0 -in .$phywin.command
		place .$phywin.caption -x 535 -y 5 -in .$phywin.command
		place .$phywin.lb0 -x 0 -y 2
		place .$phywin.save -x 590 -y 0
		place .$phywin.close -x 650 -y 0
		place .$phywin.command -x 0 -y 30
		place .$phywin.list -x 0 -y 60
		bind . <Control-Key-a> {
			.$phywin.l0 selection set 0 end
		}
		wm resizable .$phywin 0 0
	}

	.$phywin.l0 delete 0 end
	set pcount 0

	if {[file exists $filename]} {
		for {set i 0} {$i < $acount} {incr i} {
			if {[string compare $afname($i) $filename]} {} else {
				set phyname $aphyname($i)
				set caption $acaption($i)
				if {[string compare $atype($i) "-"]} {
					switch -- $atype($i) {
						"i" {
							set size "-"
							set parcent 0
							set incfile $aincfile($i)
						}
						"e" {
							if {[string compare $aparcent($i) "-"]} {
								if {$aparcent($i) != 0} {
									set size "$aparcent($i)%"
								} else {
									set size [format "%s%s%s%s" $axsize($i) $axunit($i) $aysize($i) $ayunit($i)]
								}
							} else {
								set size [format "%s%s%s%s" $axsize($i) $axunit($i) $aysize($i) $ayunit($i)]
							}
							set incfile $aincfile($i)
						}
						"l" {
							set size [format "%s%s%s%s" $axsize($i) $axunit($i) $aysize($i) $ayunit($i)]
							set parcent 0
							set incfile ""
						}
						default {
							set incfile "̤"
							set size "-"
							set parcent 0
						}
					}
					set caploc $acaploc($i)
					set loc $aloc($i)
					set attrib $aattrib($i)
					set cappt $acappt($i)
					switch -- $acappt($i) {
						"nw" {
							set cappt ""
						}
						"w" {
							set cappt ""
						}
						"sw" {
							set cappt ""
						}
						"ls" {
							set cappt ""
						}
						"cs" {
							set cappt ""
						}
						"rs" {
							set cappt ""
						}
						"se" {
							set cappt ""
						}
						"e" {
							set cappt ""
						}
						"ne" {
							set cappt ""
						}
						"rn" {
							set cappt "屦"
						}
						"cn" {
							set cappt ""
						}
						"ln" {
							set cappt "庸"
						}
						default {
							set cappt ""
						}
					}
					if {[string compare $acapaki($i) "-"]} {
						set capaki [format "%s%s" $acapaki($i) $acapunit($i)]
					} else {
						set capaki "-"
					}
					switch -- $asoroe($i) {
						"L" {
							set soroe ""
						}
						"C" {
							set soroe ""
						}
						"R" {
							set soroe ""
						}
						default {
							set soroe "-"
						}
					}
					set laki [format "%s%s" $alaki($i) $alunit($i)]
					set raki [format "%s%s" $araki($i) $arunit($i)]
				} else {
					set incfile "̤"
					set size "-"
					set cappt "-"
					set capaki "-"
					set loc "-"
					set soroe "-"
					set laki "-"
					set raki "-"
				}

				set lin [format "%-10s %-15s %-14s %-4s,%-5s  %-4s  %2s,%5s,%5s  %s" \
					$phyname $incfile $size $cappt $capaki $loc $soroe $laki $raki $caption]
				.$phywin.l0 insert end $lin
				set ${phywin}($pcount) $i
				incr pcount
			}
			set ${phywin}($pcount) -1
		}
	}
	if {$pcount > 0} {
		.$phywin.l0 selection set 0
	}
}

# ForAll.phygetphylist ¹Ը˼¹ԡ
proc getforallphy {} {
	global afname aphyname atype aincfile asize acaploc aloc aattrib aparcent acount acaption
	global acappt acapaki acapunit asoroe alaki araki alunit arunit
	global axsize aysize axunit ayunit

	set curfile ""
	if {[file exists "ForAll.phy"]} {
		set fd [open "ForAll.phy" r]
		while {[gets $fd buff] != -1} {
			regsub -all "\[\t \]+" $buff " " buff1
			regsub -all "+" $buff1 " " buff
			regsub -all " +" $buff " " buff1
			if {[string first "#" $buff1] == 0} {
				set curfile [string range $buff1 5 end]
				continue
			}
			set phyname [string range $buff1 0 [expr [string first " " $buff1] - 1]]
			for {set i 0} {$i < $acount} {incr i} {
				if {[string compare $curfile $afname($i)] || [string compare $phyname $aphyname($i)]} {} else {
					set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
					set atype($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
					set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
					switch -- $atype($i) {
						"i" {
							set aincfile($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set acaploc($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aloc($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aattrib($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set asize($i) "-"
							set axsize($i) 0
							set aysize($i) 0
							set axunit($i) "mm"
							set ayunit($i) "mm"
							set aparcent($i) 0
						}
						"e" {
							set asize($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							if {[string compare $asize($i) "-"] && [string match "*,*" $asize($i)]} {
								set xsize [string range $asize($i) 0 [expr [string first "," $asize($i)] -1]]
								set ysize [string range $asize($i) [expr [string first "," $asize($i)] +1] end]
								set axunit($i) [getunit $xsize]
								set ayunit($i) [getunit $ysize]
								set axsize($i) [getsize $xsize $axunit($i)]
								set aysize($i) [getsize $ysize $ayunit($i)]
							} else {
								set axsize($i) 0
								set aysize($i) 0
								set axunit($i) "mm"
								set ayunit($i) "mm"
							}
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set acaploc($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aloc($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aattrib($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aincfile($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aparcent($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
						}
						"l" {
							set asize($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							if {[string compare $asize($i) "-"] && [string match "*,*" $asize($i)]} {
								set xsize [string range $asize($i) 0 [expr [string first "," $asize($i)] -1]]
								set ysize [string range $asize($i) [expr [string first "," $asize($i)] +1] end]
								set axunit($i) [getunit $xsize]
								set ayunit($i) [getunit $ysize]
								set axsize($i) [getsize $xsize $axunit($i)]
								set aysize($i) [getsize $ysize $ayunit($i)]
							} else {
								set axsize($i) 0
								set aysize($i) 0
								set axunit($i) "mm"
								set ayunit($i) "mm"
							}
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set acaploc($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aloc($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aattrib($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
							set aincfile($i) "-"
							set buff1 [string range $buff1 [expr [string first " " $buff1] + 1] end]
							set aparcent($i) [string range $buff1 0 [expr [string first " " $buff1] - 1]]
						}
						"-" {
							set aincfile($i) "-"
							set asize($i) "-"
							set axsize($i) 0
							set aysize($i) 0
							set axunit($i) "mm"
							set ayunit($i) "mm"
							set acaploc($i) "-"
							set acapunit($i) "mm"
							set aloc($i) "-"
							set aattrib($i) "-"
							set aparcent($i) "0"
						}
					}
					if {[string compare $aparcent($i) "-"]} {} else {
						set aparcent($i) "0"
					}

					if {[string compare $acaploc($i) "-"]} {
						set acappt($i) [string range $acaploc($i) 1 2]
						if {[string compare $aattrib($i) "-"] && [string compare [string index $aattrib($i) 0] ","]} {
							set capaki [string range $aattrib($i) 0 [expr [string first "," $aattrib($i)] -1 ]]
							set acapunit($i) [getunit $capaki]
							set acapaki($i) [getsize $capaki $acapunit($i)]
						} else {
							set acapaki($i) "-"
							set acapunit($i) "mm"
						}
					} else {
						set acappt($i) "cs"
						set acapaki($i) "-"
						set acapunit($i) "mm"
					}

					if {[string compare $acaploc($i) "-"]} {
						set asoroe($i) [string index $acaploc($i) 0]
					} else {
						set asoroe($i) "L"
					}

					if {[string compare $aattrib($i) "-"]} {
						set raki [string range $aattrib($i) [expr [string first "," $aattrib($i)] +1] [expr [string last "," $aattrib($i)] -1 ]]
						if {[string compare $raki ""]} {
							set arunit($i) [getunit $raki]
							set araki($i) [getsize $raki $arunit($i)]
						} else {
							set araki($i) 0
							set arunit($i) "mm"
						}

						set laki [string range $aattrib($i) [expr [string last "," $aattrib($i)] +1] end]
						if {[string compare $laki ""]} {
							set alunit($i) [getunit $laki]
							set alaki($i) [getsize $laki $alunit($i)]
						} else {
							set alaki($i) 0
							set alunit($i) "mm"
						}
					} else {
						set alaki($i) 0
						set alunit($i) "mm"
						set araki($i) 0
						set arunit($i) "mm"
					}
				}
			}
		}
	}
}

# ƥե椫
proc getphylist {filename} {
	global tcl_version
	global triger tcount
	global afname aphyname atype aincfile asize acaploc aloc aattrib aparcent acount acaption 
	global axsize aysize axunit ayunit
	global acappt acapaki acapunit asoroe alaki alunit araki arunit

	if {[file exists $filename]} {
		catch {exec getphylist $filename | nkf -e} tmp
		set length [llength $tmp]
		for {set i 0} {$i < $length} {incr i 2} {
			set aphyname($acount) [lindex $tmp $i]
			if {[string length [lindex $tmp [expr $i + 1]]] == 0} {
				set acaption($acount) "<<ץʤ>>"
			} else {
				set acaption($acount) [lindex $tmp [expr $i + 1]]
			}
			set afname($acount) $filename
			set atype($acount) "-"
			set aincfile($acount) "-"
			set asize($acount) "-"
			set aparcent($acount) 0
			set acaploc($acount) "-"
			set aloc($acount) "-"
			set aattrib($acount) "-"
			set acappt($acount) "-"
			set acapaki($acount) "0"
			set acapunit($acount) "mm"
			set asoroe($acount) "-"
			set alaki($acount) 0
			set alunit($acount) "mm"
			set araki($acount) 0
			set arunit($acount) "mm"
			set axsize($acount) 0
			set aysize($acount) 0
			set axunit($acount) "mm"
			set ayunit($acount) "mm"

			incr acount
		}
	} else {
		errormsg "ƥե $filename ޤ"
	}
}

# ForAll.phyν񤭽Ф
proc writephy {} {
	global rootwd rootht
	global afname aphyname atype aincfile asize acaploc aloc aattrib aparcent acount acaption
	global axsize axunit aysize ayunit asoroe acappt acapaki acapunit alaki alunit araki arunit

	toplevel .writephy
	wm geometry .writephy +[expr $rootwd / 2 - 200]+[expr $rootht /2 - 100]
	label .writephy.lb0 -text "ɽ¸Ƥޤ"
	pack .writephy.lb0 -padx 50 -pady 50
	wm resizable .writephy 0 0
	update

	if {[file exists "ForAll.phy"]} {
		exec mv ForAll.phy ForAll.phy~
	}
	set fd [open "ForAll.phy" w]
	set curfile ""
	for {set i 0} {$i < $acount} {incr i} {
		if {[string compare $curfile $afname($i)]} {
			puts $fd "# ../$afname($i)"
			set curfile $afname($i)
		}
		set asize($i) [format "%s%s,%s%s" $axsize($i) $axunit($i) $aysize($i) $ayunit($i)]
		set acaploc($i) [format "%s%s" $asoroe($i) $acappt($i)]
		if {[string compare $acapaki($i) "-"]} {
			set capaki [format "%s%s" $acapaki($i) $acapunit($i)]
		} else {
			set capaki ""
		}
		if {[string compare $araki($i) "0"]} {
			set raki [format "%s%s" $araki($i) $arunit($i)]
		} else {
			set raki ""
		}
		if {[string compare $alaki($i) "0"]} {
			set laki [format "%s%s" $alaki($i) $alunit($i)]
		} else {
			set laki ""
		}
		set aattrib($i) [format "%s,%s,%s" $capaki $raki $laki]
		switch -- $atype($i) {
			"i" {
				set lin [format "%s\t%s\t%s\t%s\t%s\t%s\t-\t0\t%s" \
				$aphyname($i) $atype($i) $aincfile($i) $acaploc($i) $aloc($i) $aattrib($i) $acaption($i)]
				puts $fd $lin
			}
			"e" {
				set lin [format "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s" \
				$aphyname($i) $atype($i) $asize($i) $acaploc($i) $aloc($i) $aattrib($i) $aincfile($i) $aparcent($i) $acaption($i)]
				puts $fd $lin
			}
			"l" {
				set lin [format "%s\t%s\t%s\t%s\t%s\t%s\t-\t0\t%s" \
				$aphyname($i) $atype($i) $asize($i) $acaploc($i) $aloc($i) $aattrib($i) $acaption($i)]
				puts $fd $lin
			}
			default {
				set lin [format "%s\t-\t-\t-\t-\t-\t-\t0\t%s" \
				$aphyname($i) $acaption($i)]
				puts $fd $lin
			}
		}
	}

	close $fd

	after 1000
	destroy .writephy
	update
}

# ɽե
set epspre 0
proc selectfile {filename} {
	global rootwd rootht
	global curdir incfile type
	global flag epspre

	set flag 1
	if {[string length $filename] > 0} {
		set curdir [file dirname $filename]
        if {![string compare $curdir "."]} {
            set curdir ""
        }
		if {[string length $curdir] > 0} {
			set curdir ${curdir}/
		}
		set file [file tail $filename]
	}
	toplevel .selfile -width 600 -height 400 
	wm geometry .selfile +[expr $rootwd / 2 - 300]+[expr $rootht /2 - 200]
	frame .selfile.f0
	frame .selfile.f1
	frame .selfile.f2
	label .selfile.lb0 -wraplength 250 -text "ɽեꤷƤ"
	label .selfile.lb1 -wraplength 250 -text "ǥ쥯ȥ:"
	label .selfile.lb2 -wraplength 250 -text $curdir
	listbox .selfile.l0 -width 36 -height 13 -yscrollcommand ".selfile.s1 set" -selectmode single
	scrollbar .selfile.s1 -orient vertical -command ".selfile.l0 yview"
	radiobutton .selfile.list -text "ɽ/ꥹ" -variable type -value "i" -command {
		clearpreview
		showfilelist
	}
	radiobutton .selfile.eps -text "EPS" -variable type -value "e" -command {
		clearpreview
		showfilelist
	}
	checkbutton .selfile.prebutton -text "ץӥ塼" -variable epspre -onvalue "1" -offvalue "0" -command {
		if {[llength [.selfile.l0 curselection]]} {
			set file [.selfile.l0 get [.selfile.l0 curselection]]
			if {[string match "*.eps" $file] || [string match "*.EPS" $file]} {
				epspreview $curdir$file
			}
		} else {
			clearpreview
		}
	}
	radiobutton .selfile.line -text "ӡʥեʤ" -variable type -value "l" -command {
		clearpreview
		showfilelist
	}
	image create photo preview
	canvas .selfile.preview -width 256 -height 256

	frame .selfile.pref0
	listbox .selfile.prel0 -width 38 -height 14 -xscrollcommand ".selfile.pres2 set" -yscrollcommand ".selfile.pres1 set" -selectmode browse
	scrollbar .selfile.pres1 -orient vertical -command ".selfile.prel0 yview"
	scrollbar .selfile.pres2 -orient horizontal -command ".selfile.prel0 xview"

	button .selfile.ok -text "OK" -command {
		if {[llength [.selfile.l0 curselection]]} {
			set incfile ${curdir}[.selfile.l0 get [.selfile.l0 curselection]]
        } else {
			if {[string compare $type "l"]} {
				set incfile ""
				set type ""
			} else {
				set incfile ""
				set type "l"
			}
		}
		grab release .selfile
		set flag 0
		destroy .selfile
	}
	button .selfile.cancel -text "Cancel" -command {
		set incfile ""
		set type ""
		grab release .selfile
		set flag 1
		destroy .selfile
	}

	bind .selfile <Destroy> {
		if {$flag} {
			set incfile ""
			set type ""
		}
	}

	bind .selfile.l0 <ButtonRelease> {
		if {[llength [.selfile.l0 curselection]]} {
			set file [.selfile.l0 get [.selfile.l0 curselection]]
			if {[string compare $file ""]} {
				if {[string match "*.eps" $file] || [string match "*.EPS" $file]} {
					epspreview $curdir$file
				} else {
					if {[string match "*.lst" $file] || [string match "*.tbl" $file] || [string match "*.ewb" $file]} {
						listpreview $curdir$file
					} else {
						clearpreview
					}
				}
			} else {
				clearpreview
			}
		}
	}
	bind .selfile.l0 <Double-ButtonRelease> {
		if {[llength [.selfile.l0 curselection]]} {
			set file [.selfile.l0 get [.selfile.l0 curselection]]
			if {[string compare $file ""]} {
				if {[string match "*\\*" $file] || [string match "*@" $file]} {
					set file [string range $file 0 [expr [string length $file] -2]] 
				}
				if {[string compare [file type ${curdir}${file}] "link"]} {
					set dfile ${curdir}${file}
				} else {
					set dfile [file readlink ${curdir}${file}]
				}
				if {[file isdirectory $dfile]} {
					if {[string compare $file "./"]} {
						if {[string compare $file "../"]} {
							set file [.selfile.l0 get [.selfile.l0 curselection]]
							set curdir ${curdir}${file}
							.selfile.lb2 configure -text $curdir
							showfilelist
						} else {
							if {[string compare $curdir ""]} {
								if {[string last "/" [string range $curdir 0 [expr [string length $curdir] -2]]] == -1} {
									set curdir ""
									.selfile.lb2 configure -text $curdir
								} else {
									set curdir [string range $curdir 0 [string last "/" [string range $curdir 0 [expr [string length $curdir] -2]]]]
									.selfile.lb2 configure -text $curdir
								}
								showfilelist
							}
						}
					}
				}
			}
		}
	}

	showfilelist
	if {[string length $file] > 0} {
		for {set i 1} {$i <= [.selfile.l0 index end]} {incr i} {
			if {![string compare $file [.selfile.l0 get $i]]} {
				.selfile.l0 see $i
				.selfile.l0 selection set $i $i
				break
			}
		}
		if {[llength [.selfile.l0 curselection]]} {
			set file [.selfile.l0 get [.selfile.l0 curselection]]
			if {[string compare $file ""]} {
				if {[string match "*.eps" $file] || [string match "*.EPS" $file]} {
					epspreview $curdir$file
				} else {
					if {[string match "*.lst" $file] || [string match "*.tbl" $file] || [string match "*.ewb" $file]} {
						listpreview $curdir$file
					} else {
						clearpreview
					}
				}
			} else {
				clearpreview
			}
		}
	}

	grid .selfile.l0 -in .selfile.f1 -row 1 -column 0 -sticky nsew
	grid .selfile.s1 -in .selfile.f1 -row 1 -column 1 -sticky nsw
	place .selfile.lb0 -x 10 -y 10
	place .selfile.lb1 -x 10 -y 30
	place .selfile.lb2 -x 110 -y 30
	place .selfile.list -x 10 -y 50
	place .selfile.eps -x 10 -y 70
	place .selfile.prebutton -x 100 -y 70
	place .selfile.line -x 10 -y 90
	place .selfile.f1 -x 10 -y 120
	place .selfile.preview -x 300 -y 120
	place .selfile.ok -x 70 -y 360
	place .selfile.cancel -x 120 -y 360

	grab set .selfile
	wm resizable .selfile 0 0
	tkwait window .selfile
}

# ץӥ塼ξõ
proc clearpreview {} {
	set id [.selfile.preview find all]
	foreach i $id {
		.selfile.preview delete $i
	}
}

set preformat ppm

# ǤΥץӥ塼
set predir "previewdir"
proc epspreview {file} {
	global rootwd rootht
	global epspre predir preformat

	set id [.selfile.preview find all]
	foreach i $id {
		.selfile.preview delete $i
	}

	if {$epspre} {
		if {[file exists $predir]} {
			if {[file isdirectory $predir]} {
			} else {
				errormsg "ץӥ塼Ǥޤ"
				set epspre 0
			}
		} else {
			exec mkdir $predir
		}
	}

	if {$epspre} {
		exec mkdir -p $predir/[file dirname $file]
	}

	if {$epspre} {
		if {[file exists $predir/$file.$preformat]} {
			if {[file mtime $file] > [file mtime $predir/$file.$preformat]} {
				toplevel .makepreview
				wm geometry .makepreview +[expr $rootwd / 2 - 200]+[expr $rootht /2 - 100]
				label .makepreview.lb0 -text "ץӥ塼"
				pack .makepreview.lb0 -padx 50 -pady 50
				wm resizable .makepreview 0 0
				update

				catch {exec eps2$preformat $file $predir/$file.$preformat} tmp

				destroy .makepreview
				update
			}
		} else {
			toplevel .makepreview
			wm geometry .makepreview +[expr $rootwd / 2 - 150]+[expr $rootht /2 - 100]
			label .makepreview.lb0 -text "ץӥ塼"
			pack .makepreview.lb0 -padx 50 -pady 50
			wm resizable .makepreview 0 0
			update

			catch {exec eps2$preformat $file $predir/$file.$preformat} tmp

			destroy .makepreview
			update
		}
		if {[file exists $predir/$file.$preformat]} {
			set fd [open $predir/$file.$preformat "r"]
			read $fd 1
			if {[eof $fd]} {
				close $fd
				errormsg "ץӥ塼Ǥޤ\nEPSե뤬ʤǽޤ"
			} else {
				close $fd
				image create photo preview -file $predir/$file.$preformat
				.selfile.preview create image 128 128 -anchor center -image preview
			}
		} else {
			errormsg "ץӥ塼Ǥޤ"
		}
	} else {
		image create photo preview
		.selfile.preview create image 128 128 -anchor center -image preview
	}
}

# ɽ/ꥹȤΥץӥ塼
proc listpreview {file} {
	set id [.selfile.preview find all]
	foreach i $id {
		.selfile.preview delete $i
	}
	.selfile.prel0 delete 0 end
	set fd [open $file "r"]
	while {[gets $fd buff] >= 0} {
		.selfile.prel0 insert end $buff
	}
	close $fd
	grid .selfile.prel0 -in .selfile.pref0 -row 1 -column 0 -sticky nsew
	grid .selfile.pres1 -in .selfile.pref0 -row 1 -column 1 -sticky nsw
	grid .selfile.pres2 -in .selfile.pref0 -row 2 -column 0 -sticky new
	.selfile.preview create window 0 0 -anchor nw -window .selfile.pref0
}

# selfileɥ˥եɽ
proc showfilelist {} {
	global curdir predir type

	.selfile.l0 delete 0 end
	if {[string compare $type "l"]} {
		if {[string compare $curdir ""]} {
			set ls [exec /bin/ls -Fa $curdir | sed -e "s/\\(.*\\)/\\\"\\1\\\"/"]
		} else {
			set ls [exec /bin/ls -Fa | sed -e "s/\\(.*\\)/\\\"\\1\\\"/"]
		}
		foreach file $ls {
			if {[string match "*\\*" $file] || [string match "*@" $file]} {
				set file [string range $file 0 [expr [string length $file] -2]] 
			}
			if {[string compare [file type ${curdir}${file}] "link"]} {
				set dfile ${curdir}${file}
			} else {
				set dfile [file readlink ${curdir}${file}]
			}
			if {[file isdirectory $dfile]} {
				if {[string compare $file "./"] && [string compare $dfile ${predir}/]} {
					if {[string compare $curdir ""] || [string compare $file "../"]} {
						.selfile.l0 insert end $file
					}
				}
			} else {
				set ext [string tolower [file extension $dfile]]
				if {[string compare $type "e"]} {
					if {[string compare $type "i"]} {
						if {[string compare ".lst" $ext] && [string compare ".tbl" $ext] && [string compare ".ewb" $ext] && [string compare ".eps" $ext]} {} else {
							.selfile.l0 insert end $file
						}
					} else {
						if {[string compare ".lst" $ext] && [string compare ".tbl" $ext] && [string compare ".ewb" $ext]} {} else {
							.selfile.l0 insert end $file
						}
					}
				} else {
					if {[string compare ".eps" $ext]} {} else {
						.selfile.l0 insert end $file
					}
				}
			}
		}
	}
}

# ɽʸ󤫤ʬ
proc getsize {size unit} {
	if {[string match "*$unit" $size]} {
		set size [string range $size 0 [expr [string first "$unit" $size] -1]]
	} else {
		set size 0
	}
	return $size
}

# ɽʸ󤫤ñ̤
proc getunit {size} {
	if {[string match "*mm" $size]} {
		set unit "mm"
	} else {
		if {[string match "*cm" $size]} {
			set unit "cm"
		} else {
			if {[string match "*pt" $size]} {
				set unit "pt"
			} else {
				if {[string match "*H" $size]} {
					set unit "H"
				} else {
					if {[string match "*" $size]} {
						set unit ""
					} else {
						if {[string match "*" $size]} {
							set unit ""
						} else {
							set unit "mm"
						}
					}
				}
			}
		}
	}
	return $unit
}

# ޤΥ
proc setsize {} {
	global rootwd rootht
	global xsize ysize xunit yunit parcent
	global flag

	set flag 1
	toplevel .setsize -width 340 -height 190
	wm geometry .setsize +[expr $rootwd / 2 - 170]+[expr $rootht /2 - 95]
	radiobutton .setsize.size -text "/⤵EPSӤˤΤͭ" -variable selsize -value "wh" -command {
		set parcent 0
	}
	label .setsize.xlabel -text ""
	entry .setsize.xsize -width 8 -textvariable xsize
	menubutton .setsize.xunit -text $xunit  -relief raised -menu .setsize.xunit.m0
	menu .setsize.xunit.m0 -tearoff false
	.setsize.xunit.m0 add command -label "mm" -command {
		set xunit "mm"
		.setsize.xunit configure -text "mm"
	}
	.setsize.xunit.m0 add command -label "cm" -command {
		set xunit "cm"
		.setsize.xunit configure -text "cm"
	}
	.setsize.xunit.m0 add command -label "pt" -command {
		set xunit "pt"
		.setsize.xunit configure -text "pt"
	}
	.setsize.xunit.m0 add command -label "H" -command {
		set xunit "H"
		.setsize.xunit configure -text "H"
	}
	.setsize.xunit.m0 add command -label "" -command {
		set xunit "ji"
		.setsize.xunit configure -text ""
	}

	label .setsize.ylabel -text "⤵"
	entry .setsize.ysize -width 8 -textvariable ysize

	menubutton .setsize.yunit -text $yunit  -relief raised -menu .setsize.yunit.m0
	menu .setsize.yunit.m0 -tearoff false
	.setsize.yunit.m0 add command -label "mm" -command {
		set yunit "mm"
		.setsize.yunit configure -text "mm"
	}
	.setsize.yunit.m0 add command -label "cm" -command {
		set yunit "cm"
		.setsize.yunit configure -text "cm"
	}
	.setsize.yunit.m0 add command -label "pt" -command {
		set yunit "pt"
		.setsize.yunit configure -text "pt"
	}
	.setsize.yunit.m0 add command -label "H" -command {
		set yunit "H"
		.setsize.yunit configure -text "H"
	}
	.setsize.yunit.m0 add command -label "" -command {
		set yunit "gyo"
		.setsize.yunit configure -text ""
	}

	radiobutton .setsize.par -text "ΨEPSΤߤͭ" -variable selsize -value "par" -command {
		if {[string compare $parcent "-"]} {
			if {$parcent == 0} {
				set parcent 100
			}
		} else {
			set parcent 100
		}
	}
	label .setsize.plabel -text "Ψ"
	entry .setsize.parcent -width 8 -textvariable parcent
	label .setsize.plabel2 -text "%"
	button .setsize.ok -text "OK" -command {
		if {[string compare $selsize "par"]} {
			set parcent 0
		}
		grab release .setsize
		set flag 0
		destroy .setsize
	}
	button .setsize.cancel -text "Cancel" -command {
		set parcent ""
		grab release .setsize
		set flag 1
		destroy .setsize
	}

	bind .setsize <Destroy> {
		if {$flag} {
			set parcent ""
		}
	}

	place .setsize.size -x 10 -y 10
	place .setsize.xlabel -x 10 -y 40
	place .setsize.xsize -x 60 -y 40
	place .setsize.xunit -x 130 -y 40
	place .setsize.ylabel -x 10 -y 70
	place .setsize.ysize -x 60 -y 70
	place .setsize.yunit -x 130 -y 70
	place .setsize.par -x 10 -y 100
	place .setsize.plabel -x 10 -y 130
	place .setsize.parcent -x 60 -y 130
	place .setsize.plabel2 -x 130 -y 130
	place .setsize.ok -x 120 -y 160
	place .setsize.cancel -x 170 -y 160

	if {[string compare $parcent "-"]} {
		if {$parcent != 0} {
			.setsize.par select
			set selsize "par"
		}
	}

	grab set .setsize
	wm resizable .setsize 0 0
	tkwait window .setsize
}

# ץ֤
proc setcaploc {} {
	global rootwd rootht
	global cappt capaki capunit
	global flag

	set flag 1
	toplevel .setcaploc -width 400 -height 350
	wm geometry .setcaploc +[expr $rootwd / 2 - 200]+[expr $rootht /2 - 175]
	label .setcaploc.lb0 -text "ޤФ륭ץ֡ʥꥹ/ɽˤϾ岼Τͭ"
	label .setcaploc.lb1 -text "" -background white -padx 70 -pady 60
	radiobutton .setcaploc.wn -text "" -value "nw" -var cappt
	radiobutton .setcaploc.wc -text "" -value "w" -var cappt
	radiobutton .setcaploc.ws -text "" -value "sw" -var cappt
	radiobutton .setcaploc.sw -text "" -value "ls" -var cappt
	radiobutton .setcaploc.sc -text "" -value "cs" -var cappt
	radiobutton .setcaploc.se -text "" -value "rs" -var cappt
	radiobutton .setcaploc.es -text "" -value "se" -var cappt
	radiobutton .setcaploc.ec -text "" -value "e" -var cappt
	radiobutton .setcaploc.en -text "" -value "ne" -var cappt
	radiobutton .setcaploc.ne -text "屦" -value "rn" -var cappt
	radiobutton .setcaploc.nc -text "" -value "cn" -var cappt
	radiobutton .setcaploc.nw -text "庸" -value "ln" -var cappt
	label .setcaploc.lb2 -text "ޤȥץȤΥ"
	entry .setcaploc.aki -width 8 -textvariable capaki
	menubutton .setcaploc.capunit -text $capunit  -relief raised -menu .setcaploc.capunit.m0
	menu .setcaploc.capunit.m0 -tearoff false
	.setcaploc.capunit.m0 add command -label "mm" -command {
		set capunit "mm"
		.setcaploc.capunit configure -text "mm"
	}
	.setcaploc.capunit.m0 add command -label "cm" -command {
		set capunit "cm"
		.setcaploc.capunit configure -text "cm"
	}
	.setcaploc.capunit.m0 add command -label "pt" -command {
		set capunit "pt"
		.setcaploc.capunit configure -text "pt"
	}
	.setcaploc.capunit.m0 add command -label "H" -command {
		set capunit "H"
		.setcaploc.capunit configure -text "H"
	}
	.setcaploc.capunit.m0 add command -label "" -command {
		set capunit "gyo"
		.setcaploc.capunit configure -text ""
	}
	checkbutton .setcaploc.default -text "ǥեȤΥ" -variable capaki -onvalue "-" -offvalue "0"
	button .setcaploc.ok -text "OK" -command {
		grab release .setcaploc
		set flag 0
		destroy .setcaploc
	}
	button .setcaploc.cancel -text "Cancel" -command {
		set cappt ""
		grab release .setcaploc
		set flag 1
		destroy .setcaploc
	}

	bind .setcaploc <Destroy> {
		if {$flag} {
			set cappt ""
		}
	}

	place .setcaploc.lb0 -x 10 -y 10
	place .setcaploc.lb1 -x 80 -y 70
	place .setcaploc.wn -x 10 -y 70
	place .setcaploc.wc -x 10 -y 130
	place .setcaploc.ws -x 10 -y 190
	place .setcaploc.sw -x 80 -y 220
	place .setcaploc.sc -x 140 -y 220
	place .setcaploc.se -x 200 -y 220
	place .setcaploc.es -x 260 -y 190
	place .setcaploc.ec -x 260 -y 130
	place .setcaploc.en -x 260 -y 70
	place .setcaploc.ne -x 200 -y 30
	place .setcaploc.nc -x 140 -y 30
	place .setcaploc.nw -x 80 -y 30
	place .setcaploc.lb2 -x 0 -y 250
	place .setcaploc.aki -x 40 -y 280
	place .setcaploc.capunit -x 110 -y 280
	place .setcaploc.default -x 200 -y 280
	place .setcaploc.ok -x 150 -y 320
	place .setcaploc.cancel -x 200 -y 320

	grab set .setcaploc
	wm resizable .setcaploc 0 0
	tkwait window .setcaploc
}

# ɽνϰ֤
proc setloc {} {
	global rootwd rootht
	global loc
	global flag

	set flag 1
	toplevel .setloc -width 350 -height 160
	wm geometry .setloc +[expr $rootwd / 2 - 175]+[expr $rootht /2 - 80]
	label .setloc.lb0 -text "ɽΥڡ:"
	label .setloc.loc -text $loc
	checkbutton .setloc.here -text "ȥꥬäƤ֤˽" -variable here -onvalue "h" -offvalue "" -command {
		set loc "$here$top$bottom$page"
		.setloc.loc configure -text $loc
	}
	checkbutton .setloc.top -text "ڡƬ˽" -variable top -onvalue "t" -offvalue "" -command {
		set loc "$here$top$bottom$page"
		.setloc.loc configure -text $loc
	}
	checkbutton .setloc.bottom -text "ȥꥬΥڡޤϼڡ˽" -variable bottom -onvalue "b" -offvalue "" -command {
		set loc "$here$top$bottom$page"
		.setloc.loc configure -text $loc
	}
	checkbutton .setloc.page -text "ڡʹߤ˿ɽΥڡäƽ" -variable page -onvalue "p" -offvalue "" -command {
		set loc "$here$top$bottom$page"
		.setloc.loc configure -text $loc
	}
	button .setloc.ok -text "OK" -command {
		grab release .setloc
		set flag 0
		destroy .setloc
	}
	button .setloc.cancel -text "Cancel" -command {
		set loc "-"
		grab release .setloc
		set flag 1
		destroy .setloc
	}

	bind .setloc <Destroy> {
		if {$flag} {
			set loc "-"
		}
	}

	if {[string match "*h*" $loc]} {
		.setloc.here select
		set here "h"
	} else {
		.setloc.here deselect
		set here ""
	}
	if {[string match "*t*" $loc]} {
		.setloc.top select
		set top "t"
	} else {
		.setloc.top deselect
		set top ""
	}
	if {[string match "*b*" $loc]} {
		.setloc.bottom select
		set bottom "b"
	} else {
		.setloc.bottom deselect
		set bottom ""
	}
	if {[string match "*p*" $loc]} {
		.setloc.page select
		set page "p"
	} else {
		.setloc.page deselect
		set page ""
	}

	place .setloc.lb0 -x 10 -y 10
	place .setloc.loc -x 140 -y 10
	place .setloc.here -x 10 -y 40
	place .setloc.top -x 10 -y 60
	place .setloc.bottom -x 10 -y 80
	place .setloc.page -x 10 -y 100
	place .setloc.ok -x 120 -y 130
	place .setloc.cancel -x 170 -y 130

	grab set .setloc
	wm resizable .setloc 0 0
	tkwait window .setloc
}

# ɽνϰ֤
proc setloc2 {} {
	global rootwd rootht
	global loc
	global flag

	set flag 1
	toplevel .setloc -width 400 -height 310
	wm geometry .setloc +[expr $rootwd / 2 - 200]+[expr $rootht /2 - 155]
	label .setloc.lb0 -text "ɽΥڡ:"
	label .setloc.loc -text $loc
	label .setloc.lb1 -text "h (here)  : ȥꥬäƤ֤˽"
	label .setloc.lb2 -text "t (top)   : ڡƬ˽"
	label .setloc.lb3 -text "b (bottom): ȥꥬΥڡޤϼڡ˽"
	label .setloc.lb4 -text "p (page)  : ڡʹߤ˿ɽΥڡäƽ"
	label .setloc.lb5 -text "ͥ"
	label .setloc.lb6 -text "1:"
	label .setloc.lb7 -text "2:"
	label .setloc.lb8 -text "3:"
	label .setloc.lb9 -text "4:"
	menubutton .setloc.pos0 -width 8 -relief raised -menu .setloc.pos0.m0
	menu .setloc.pos0.m0 -tearoff false
	.setloc.pos0.m0 add command -label "h" -command {
		set loc "h[string range $loc 1 end]"
		.setloc.pos0 configure -text "h"
		setlocmenu
	}
	.setloc.pos0.m0 add command -label "t" -command {
		set loc "t[string range $loc 1 end]"
		.setloc.pos0 configure -text "t"
		setlocmenu
	}
	.setloc.pos0.m0 add command -label "b" -command {
		set loc "b[string range $loc 1 end]"
		.setloc.pos0 configure -text "b"
		setlocmenu
	}
	.setloc.pos0.m0 add command -label "p" -command {
		set loc "p[string range $loc 1 end]"
		.setloc.pos0 configure -text "p"
		setlocmenu
	}

	menubutton .setloc.pos1 -width 8 -relief raised -menu .setloc.pos1.m0
	menu .setloc.pos1.m0 -tearoff false
	.setloc.pos1.m0 add command -label "h" -command {
		set loc "[string index $loc 0]h[string range $loc 2 end]"
		.setloc.pos1 configure -text "h"
		setlocmenu
	}
	.setloc.pos1.m0 add command -label "t" -command {
		set loc "[string index $loc 0]t[string range $loc 2 end]"
		.setloc.pos1 configure -text "t"
		setlocmenu
	}
	.setloc.pos1.m0 add command -label "b" -command {
		set loc "[string index $loc 0]b[string range $loc 2 end]"
		.setloc.pos1 configure -text "b"
		setlocmenu
	}
	.setloc.pos1.m0 add command -label "p" -command {
		set loc "[string index $loc 0]p[string range $loc 2 end]"
		.setloc.pos1 configure -text "p"
		setlocmenu
	}
	.setloc.pos1.m0 add command -label "ʤ" -command {
		set loc "[string index $loc 0][string range $loc 2 end]"
		.setloc.pos1 configure -text ""
		setlocmenu
	}

	menubutton .setloc.pos2 -width 8 -relief raised -menu .setloc.pos2.m0
	menu .setloc.pos2.m0 -tearoff false
	.setloc.pos2.m0 add command -label "h" -command {
		set loc "[string range $loc 0 1]h[string index $loc 3]"
		.setloc.pos2 configure -text "h"
		setlocmenu
	}
	.setloc.pos2.m0 add command -label "t" -command {
		set loc "[string range $loc 0 1]t[string index $loc 3]"
		.setloc.pos2 configure -text "t"
		setlocmenu
	}
	.setloc.pos2.m0 add command -label "b" -command {
		set loc "[string range $loc 0 1]b[string index $loc 3]"
		.setloc.pos2 configure -text "b"
		setlocmenu
	}
	.setloc.pos2.m0 add command -label "p" -command {
		set loc "[string range $loc 0 1]p[string index $loc 3]"
		.setloc.pos2 configure -text "p"
		setlocmenu
	}
	.setloc.pos2.m0 add command -label "ʤ" -command {
		set loc "[string range $loc 0 1][string index $loc 3]"
		.setloc.pos2 configure -text ""
		setlocmenu
	}

	menubutton .setloc.pos3 -width 8 -relief raised -menu .setloc.pos3.m0
	menu .setloc.pos3.m0 -tearoff false
	.setloc.pos3.m0 add command -label "h" -command {
		set loc "[string range $loc 0 2]h"
		.setloc.pos3 configure -text "h"
		setlocmenu
	}
	.setloc.pos3.m0 add command -label "t" -command {
		set loc "[string range $loc 0 2]t"
		.setloc.pos3 configure -text "t"
		setlocmenu
	}
	.setloc.pos3.m0 add command -label "b" -command {
		set loc "[string range $loc 0 2]b"
		.setloc.pos3 configure -text "b"
		setlocmenu
	}
	.setloc.pos3.m0 add command -label "p" -command {
		set loc "[string range $loc 0 2]p"
		.setloc.pos3 configure -text "p"
		setlocmenu
	}
	.setloc.pos3.m0 add command -label "ʤ" -command {
		set loc [string range $loc 0 2]
		.setloc.pos3 configure -text ""
		setlocmenu
	}

	button .setloc.ok -text "OK" -command {
		grab release .setloc
		set flag 0
		destroy .setloc
	}
	button .setloc.cancel -text "Cancel" -command {
		set loc "-"
		grab release .setloc
		set flag 1
		destroy .setloc
	}

	bind .setloc <Destroy> {
		if {$flag} {
			set loc "-"
		}
	}

	if {[string compare $loc ""] && [string compare $loc "-"]} {} else {
		set loc "htb"
	}

	setlocmenu

	place .setloc.lb0 -x 10 -y 10
	place .setloc.loc -x 140 -y 10
	place .setloc.lb1 -x 10 -y 40
	place .setloc.lb2 -x 10 -y 60
	place .setloc.lb3 -x 10 -y 80
	place .setloc.lb4 -x 10 -y 100
	place .setloc.lb5 -x 10 -y 130
	place .setloc.lb6 -x 10 -y 150
	place .setloc.pos0 -x 40 -y 150
	place .setloc.lb7 -x 10 -y 180
	place .setloc.pos1 -x 40 -y 180
	place .setloc.lb8 -x 10 -y 210
	place .setloc.pos2 -x 40 -y 210
	place .setloc.lb9 -x 10 -y 240
	place .setloc.pos3 -x 40 -y 240
	place .setloc.ok -x 120 -y 280
	place .setloc.cancel -x 170 -y 280

	grab set .setloc
	wm resizable .setloc 0 0
	tkwait window .setloc
}

proc setlocmenu {} {
	global loc

	for {set i 0} {$i < [expr [string length $loc] -1]} {incr i} {
		for {set j [expr $i +1]} {$j < [string length $loc]} {incr j} {
			if {[string compare [string index $loc $i] [string index $loc $j]]} {} else {
				set loc [string range $loc 0 [expr $j - 1]][string range $loc [expr $j + 1] end]
				incr j -1
			}
		}
	}

	.setloc.loc configure -text $loc

	set pos [string index $loc 0]
	.setloc.pos0 configure -text $pos
	set pos [string index $loc 1]
	if {[string compare $pos ""]} {
		.setloc.pos1 configure -text $pos
		set pos [string index $loc 2]
		if {[string compare $pos ""]} {
			.setloc.pos2 configure -text $pos
			set pos [string index $loc 3]
			if {[string compare $pos ""]} {
				.setloc.pos3 configure -text $pos
			} else {
				.setloc.pos3 configure -text "ʤ"
			}
		} else {
			.setloc.pos2 configure -text "ʤ"
			.setloc.pos3 configure -text "ʤ"
		}
	} else {
		.setloc.pos1 configure -text "ʤ"
		.setloc.pos2 configure -text "ʤ"
		.setloc.pos3 configure -text "ʤ"
	}
}

# ·
proc setaki {} {
	global rootwd rootht
	global soroe laki raki lunit runit
	global flag

	set flag 1
	toplevel .setaki -width 400 -height 260
	wm geometry .setaki +[expr $rootwd / 2 - 200]+[expr $rootht /2 - 130]
	radiobutton .setaki.rb0 -text "·" -variable soroe -value "L" -command {
		writesoroe "L"
	}
	radiobutton .setaki.rb1 -text "󥿡·" -variable soroe -value "C" -command {
		writesoroe "C"
	}
	radiobutton .setaki.rb2 -text "·" -variable soroe -value "R" -command {
		writesoroe "R"
	}
	canvas .setaki.cv -width 400 -height 200
	entry .setaki.le -width 5 -textvariable laki
	entry .setaki.re -width 5 -textvariable raki

	.setaki.cv create line 10 0 10 200
	.setaki.cv create line 390 0 390 200
	.setaki.cv create text 200 20 -text "ʸ"
	.setaki.cv create line 10 20 170 20 -arrow first -arrowshape {5 8 3}
	.setaki.cv create line 230 20 390 20 -arrow last -arrowshape {5 8 3}

	menubutton .setaki.lunit -text $lunit -relief raised -padx 3 -pady 2 -menu .setaki.lunit.m0
	menu .setaki.lunit.m0 -tearoff false
	.setaki.lunit.m0 add command -label "mm" -command {
		set lunit "mm"
		.setaki.lunit configure -text "mm"
	}
	.setaki.lunit.m0 add command -label "cm" -command {
		set lunit "cm"
		.setaki.lunit configure -text "cm"
	}
	.setaki.lunit.m0 add command -label "pt" -command {
		set lunit "pt"
		.setaki.lunit configure -text "pt"
	}
	.setaki.lunit.m0 add command -label "H" -command {
		set lunit "H"
		.setaki.lunit configure -text "H"
	}
	.setaki.lunit.m0 add command -label "" -command {
		set lunit ""
		.setaki.lunit configure -text ""
	}

	menubutton .setaki.runit -text $runit -relief raised -padx 3 -pady 2 -menu .setaki.runit.m0
	menu .setaki.runit.m0 -tearoff false
	.setaki.runit.m0 add command -label "mm" -command {
		set runit "mm"
		.setaki.runit configure -text "mm"
	}
	.setaki.runit.m0 add command -label "cm" -command {
		set runit "cm"
		.setaki.runit configure -text "cm"
	}
	.setaki.runit.m0 add command -label "pt" -command {
		set runit "pt"
		.setaki.runit configure -text "pt"
	}
	.setaki.runit.m0 add command -label "H" -command {
		set runit "H"
		.setaki.runit configure -text "H"
	}
	.setaki.runit.m0 add command -label "" -command {
		set runit ""
		.setaki.runit configure -text ""
	}

	button .setaki.ok -text "OK" -command {
		grab release .setaki
		set flag 0
		destroy .setaki
	}
	button .setaki.cancel -text "Cancel" -command {
		set soroe ""
		grab release .setaki
		set flag 1
		destroy .setaki
	}

	bind .setaki <Destroy> {
		if {$flag} {
			set soroe ""
		}
	}

	place .setaki.rb0 -x 0 -y 0
	place .setaki.rb1 -x 140 -y 0
	place .setaki.rb2 -x 330 -y 0
	place .setaki.cv -x 0 -y 30
	place .setaki.ok -x 130 -y 230
	place .setaki.cancel -x 180 -y 230

	writesoroe $soroe

	grab set .setaki
	wm resizable .setaki 0 0
	tkwait window .setaki
}

# ·˱ƿޤ
proc writesoroe {soroe} {
	.setaki.cv create rectangle 11 40 389 180 -outline gray85 -fill gray85
	if {[string compare $soroe "C"]} {
		if {[string compare $soroe "R"]} {
			.setaki.cv create rectangle 11 40 270 180 -outline gray50
			.setaki.cv create rectangle 90 50 190 170 -fill white
			.setaki.cv create text 140 110 -text ""
			.setaki.cv create text 40 90 -text  ""
			.setaki.cv create line 11 105 90 105 -arrow both -arrowshape {5 8 3}
			.setaki.cv create text 215 90 -text  ""
			.setaki.cv create line 190 105 270 105 -arrow both -arrowshape {5 8 3}
			place .setaki.le -x 12 -y 145
			place .setaki.lunit -x 60 -y 145
			place .setaki.re -x 192 -y 145
			place .setaki.runit -x 240 -y 145
		} else {
			.setaki.cv create rectangle 130 40 389 180 -outline gray50
			.setaki.cv create rectangle 210 50 310 170 -fill white
			.setaki.cv create text 260 110 -text ""
			.setaki.cv create text 160 90 -text  ""
			.setaki.cv create line 130 105 210 105 -arrow both -arrowshape {5 8 3}
			.setaki.cv create text 335 90 -text  ""
			.setaki.cv create line 310 105 389 105 -arrow both -arrowshape {5 8 3}
			place .setaki.le -x 132 -y 145
			place .setaki.lunit -x 180 -y 145
			place .setaki.re -x 312 -y 145
			place .setaki.runit -x 360 -y 145
		}
	} else {
		.setaki.cv create rectangle 70 40 330 180 -outline gray50
		.setaki.cv create rectangle 150 50 250 170 -fill white
		.setaki.cv create text 200 110 -text ""
		.setaki.cv create text 100 90 -text  ""
		.setaki.cv create line 70 105 150 105 -arrow both -arrowshape {5 8 3}
		.setaki.cv create text 275 90 -text  ""
		.setaki.cv create line 250 105 330 105 -arrow both -arrowshape {5 8 3}
		place .setaki.le -x 72 -y 145
		place .setaki.lunit -x 120 -y 145
		place .setaki.re -x 252 -y 145
		place .setaki.runit -x 300 -y 145
	}
}
