;;; novice-search.el --- Search Functions for novice user.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(defun novice-search (s)
  (interactive "sNovice Search: ")
  (setq isearch-string s)
  (setq search-last-string isearch-string)
  (or (search-forward isearch-string nil t)
      (novice-search-failed-message ""))
  ;; Update the isearch ring data.
  (if (not (setq search-ring-yank-pointer
		 ;; really need equal test instead of eq.
		 (member isearch-string search-ring)))
      (progn
	(setq search-ring (cons isearch-string search-ring)
	      search-ring-yank-pointer search-ring)
	(if (> (length search-ring) search-ring-max)
	    (setcdr (nthcdr (1- search-ring-max) search-ring) nil)))))

(defun novice-search-repeat-forward ()
  (interactive)
  (or (search-forward isearch-string nil t)
      (novice-search-failed-message "")))

(defun novice-search-repeat-backward ()
  (interactive)
  (or (search-backward isearch-string nil t)
      (novice-search-failed-message "")))

(defun novice-search-failed-message (s)
  (message (format "%sʸ\'%s\'ϸĤޤ" s isearch-string))
  (beep))


;(global-set-key "\C-c\C-s" 'novice-search-repeat-forward)
;(global-set-key "\C-c\C-r" 'novice-search-repeat-backward)


(provide 'novice-search)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; novice-search.el ends here.
