%%
%% title: Dcoument class for ASCII's special packages.
%% author: Ken Nakano (ken-na@ascii.co.jp)
%%
\ProvidesClass{ascltxdoc}[1997/04/25 v1.0 Class for ASCII's special macros]
\LoadClassWithOptions{jltxdoc}

\let\orgmeta\meta
\def\meta#1{\orgmeta{\hskip-\lastskip#1}}
\def\file#1{\textsf{#1}}
\def\backskip{\vskip-\baselineskip}
%
\newenvironment{syntax}{\begin{synt@x}{ʸ}}{\end{synt@x}}
\newenvironment{Usage}{\begin{synt@x}{Ȥ}}{\end{synt@x}}
\newenvironment{synt@x}[1]%
  {\par\vspace{.5\baselineskip}%
   \noindent\begin{minipage}{\linewidth}%
   \noindent\hbox to\linewidth{\textbf{#1}
       \leaders\hrule height3pt depth-2pt\hfill}%
   \begin{tabbing}\=01234\=0123456\=0123456789\=\+\kill}%
  {\end{tabbing}%
   \noindent\hbox to\linewidth{%
       \leaders\hrule height3pt depth-2pt\hfill}%
   \end{minipage}%
   \par\nointerlineskip\vspace{.3\baselineskip}}

\endinput
