#!/usr/bin/perl
#
# checksumfix.pl - log ե뤫 checksum dtx ե
#                                                         (C) 2000 H.Togashi
#
use FileHandle;
exit(main());

#------------------------------------------------------------
# routines
#
sub main {
  if (@ARGV) {
    for (@ARGV) {
      FixNum($_);
    }
  }
  else {
    Usage();
  }
}

sub FixNum {
  my ($dtx) = @_;
  my ($log) = $dtx;
  $log =~ s/\.dtx/\.log/;
  my ($fh) = new FileHandle "< $log";
  unless (defined $fh) {
    print STDERR "Cannot open $log\n";
    return -1;
  }
  else {
    my (@loglist) = <$fh>;
    undef $fh;
    for (@loglist) {
      /\((.+?\.dtx)/ && do {
	$dtx = $1;
      };
      /^! Package doc Error: Checksum not passed.+\<\>([0-9]+)\).+/ && do {
	SetFixedNum($dtx, $1);
      };
    }
  }
  return 0;
}

sub SetFixedNum {
  my ($dtx, $num) = @_;
  my (@list);

  my ($fh) = new FileHandle "< $dtx";
  unless (defined $fh) {
    print STDERR "Cannot open $dtx\n";
    return -1;
  }
  else {
    @list = <$fh>;
    undef $fh;
    for (@list) {
      if (/^\%\s*\\CheckSum\{$num\}/) {
	print "already fixed $dtx\n";
	return 0;
      }
    }
  }

  my ($back) = "$dtx" . "~";
  unlink $back if (-f $back);
  rename $dtx, $back;

  my ($fh) = new FileHandle "> $dtx";
  unless (defined $fh) {
    print STDERR "Cannot open $dtx\n";
    return -1;
  }
  else {
    for (@list) {
      s/^\%(\s*)\\CheckSum\{[0-9]+\}/\%$1\\CheckSum\{$num\}/;
      print $fh $_;
    }
    undef $fh;
  }
  print "fix $dtx\n";
  return 0;
}

sub Usage {
  my ($basename) = $0;
  $basename =~ s!.*/!!;
  print<<EOF

  usage: perl $basename dtx_filenames...

	'dtx_filename' may not be an included dtx file, as it has no log.

EOF
}
