#!/bin/sh
# ʸեץ
# (c)2001 ҥ
#
# makejseries.sh <PSե̾> <PSTFM̾>
#
MKDIR="mkdir -p"

TEXMF=`kpsewhich --expand-var='$TEXMFMAIN'`
TFMDIR=$TEXMF/fonts/tfm/pskanji
VFDIR=$TEXMF/fonts/vf/pskanji

progname=`basename $0`
usage() {
	echo "Usage: $progname psname texname"
	echo " ex, $progname Ryumin-Light ryumin-l"
	exit
}

setdir() {
    case $1 in
      -ba) dir=cho1 ;;
      -ca) dir=cho2 ;;
      -da) dir=cho3 ;;
      -ea) dir=cho4 ;;
      -ga) dir=hira1 ;;
      -ha) dir=hira2 ;;
      -ia) dir=hira3 ;;
      -ja) dir=hira4 ;;
      -ab) dir=xp1 ;;
      -ac) dir=xp2 ;;
      -ad) dir=xp3 ;;
      -ae) dir=xm1 ;;
      -af) dir=xm2 ;;
      -ag) dir=xm3 ;;
      *) dir=normal ;;
    esac
}

test $# -ne 2 && usage

echo "creating VF of $1 ..."
./jnormal $1 $2
./tnormal $1 $2
for var in 1 2 3 4; do
	./jchotai $var $1 $2
	./jheitai $var $1 $2
	./tchotai $var $1 $2
	./theitai $var $1 $2
done
for var in 1 2 3 -1 -2 -3; do
	./jshatai $var $1 $2
	./tshatai $var $1 $2
done

for var in "" -ba -ca -da -ea -ga -ha -ia -ja -ab -ac -ad -ae -af -ag; do
    setdir $var
    $MKDIR $TFMDIR/$dir && mv -f $1-H${var}.tfm $1-V${var}.tfm $2${var}.tfm $2-v${var}.tfm $TFMDIR/$dir
    $MKDIR $VFDIR/$dir && mv -f $1-H${var}.vf $1-V${var}.vf $VFDIR/$dir
done
