#!/bin/sh
# °ʸեץ
# (c)2001 ҥ
#
# makeseries.sh <TFM̾>
#
MKDIR="mkdir -p"

TEXMF=`kpsewhich --expand-var='$TEXMFMAIN'`
TFMDIR=$TEXMF/fonts/tfm/psrelkanji

progname=`basename $0`
usage() {
	echo "Usage: $progname tfmname"
	echo " ex, $progname rpptmr"
	exit
}

setdir() {
    case $1 in
      -ba) dir=cho1 ;;
      -ca) dir=cho2 ;;
      -da) dir=cho3 ;;
      -ea) dir=cho4 ;;
      -ga) dir=hira1 ;;
      -ha) dir=hira2 ;;
      -ia) dir=hira3 ;;
      -ja) dir=hira4 ;;
      -ab) dir=xp1 ;;
      -ac) dir=xp2 ;;
      -ad) dir=xp3 ;;
      -ae) dir=xm1 ;;
      -af) dir=xm2 ;;
      -ag) dir=xm3 ;;
      *) dir=normal ;;
    esac
}

test $# -ne 1 && usage

echo "creating TFM of $1 ..."
./normal $1
for var in 1 2 3 4; do
	./chotai $var $1
	./heitai $var $1
done
for var in 1 2 3 -1 -2 -3; do
	./shatai $var $1
done

for var in "" -ba -ca -da -ea -ga -ha -ia -ja -ab -ac -ad -ae -af -ag; do
    setdir $var
    $MKDIR $TFMDIR/$dir && mv -f $1${var}.tfm $TFMDIR/$dir
done
