'''
expEYES program
Author  : Ajith Kumar B.P, bpajith@gmail.com
License : GNU GPL version 3
'''

from Tkinter import *
import expeyes.mca
import expeyes.eyeplot as eyeplot, expeyes.eyemath as eyemath, time

TIMER = 1000
WIDTH  = 600   # width of drawing canvas
HEIGHT = 400   # height 
VPERDIV = 1.0  # Volts per division, vertical scale
NCHAN  = 512
running = False


def set_scale(w):
	global delay, NP, NC, VPERDIV
	divs = [1.0, 0.5, 0.2]
	#VPERDIV = divs[int(vpd.get())]
	g.setWorld(0,0, NCHAN, 100,'E','dN')

def update():
	refresh()

def refresh():
	global running
	if running == True:
		ch,nn = p.read_hist()
		m = p.maximum(nn)
		g.setWorld(0,0, NCHAN, m*1.1,'E','dN')
		g.delete_lines()
		g.line(ch,nn)
		root.after(TIMER,update)
		print 'Done'

def start():
	global running
	p.start_hist()
	running = True
	root.after(TIMER,update)
	msg('Acquisition Started')

def stop():
	global running
	running = False
	p.stop_hist()
	msg('Acquisition stopped by user')

def clear():
	p.clear_hist()
	g.delete_lines()
	msg('Spectrum Cleared by user')

def save():
	pass

def fit_curve():
	pass

def msg(s, col = 'blue'):
	msgwin.config(text=s, fg=col)

p = expeyes.mca.open()
root = Tk()
Canvas(root, width = WIDTH, height = 5).pack(side=TOP)  # Some space at the top
g = eyeplot.graph(root, width=WIDTH, height=HEIGHT)	    # make plot objects using draw.disp
g.setWorld(0, -5, 20, 5,'E','dN/dE')

cf = Frame(root, width = WIDTH, height = 10)
cf.pack(side=TOP,  fill = BOTH, expand = 1)
scale = Scale(cf,command = set_scale, orient=HORIZONTAL, length=50, showvalue=False,\
	from_ = 0, to=9, resolution=1)
scale.pack(side=LEFT, anchor = SW)

b1 = Button(cf, text = 'REFRESH', command = refresh)
b1.pack(side = LEFT, anchor = N)
b1 = Button(cf, text = 'START', command = start)
b1.pack(side = LEFT, anchor = N)
b1 = Button(cf, text = 'STOP', command = stop)
b1.pack(side = LEFT, anchor = N)
b4 = Button(cf, text = 'CLEAR', command = clear)
b4.pack(side = LEFT, anchor = N)
b3 = Button(cf, text = 'SAVE to', command = save)
b3.pack(side = LEFT, anchor = N)
filename = StringVar()
e1 =Entry(cf, width=15, bg = 'white', textvariable = filename)
filename.set('hist.dat')
e1.pack(side = LEFT)
FIT = IntVar()
b=Checkbutton(cf,text='FIT', command = fit_curve, variable=FIT, fg= 'black')
b.pack(side=LEFT, anchor = SW)
b5 = Button(cf, text = 'QUIT', command = sys.exit)
b5.pack(side = RIGHT, anchor = N)

mf = Frame(root)				# Message Frame below command frame.
mf.pack(side=TOP, anchor = SW)
msgwin = Label(mf,text = 'Messages', fg = 'blue')
msgwin.pack(side=LEFT, anchor = SW)

root.title('EYES MCA Program')
root.after(TIMER,update)
root.mainloop()

