/***************************************************************************
                          FLSessionDB.cpp  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLApplication.h"
#include "FLSessionDB.h"
#include <qsettings.h>

FLSessionDB::FLSessionDB (QWidget * parent, const char *name, WFlags fl):
FLWidgetConnectDB (parent, name, fl), error_ (false)
{
  QSettings settings;
  QString keybase ("/facturalux/" VERSION "/");

  // Vamos a cargar los valores guardados durante la configuracin.
  lineEditUser->setText (settings.readEntry (keybase + "DBA/username"));
  lineEditPassword->setText (settings.readEntry (keybase + "DBA/password"));
  lineEditPort->setText (settings.readEntry (keybase + "DBA/port"));
  lineEditHost->setText (settings.readEntry (keybase + "DBA/hostname"));
  lineEditUser->setFocus ();
  setFont (qApp->font ());
}

FLSessionDB::~FLSessionDB ()
{
}

void
FLSessionDB::tryConnect ()
{
  QSqlDatabase *facturalux = QSqlDatabase::database (QSqlDatabase::defaultConnection, false);

  if (facturalux->isOpen ())
	facturalux->close ();

  facturalux->setDatabaseName ("facturalux");

  QString user = lineEditUser->text ();
  QString password = lineEditPassword->text ();

  if (user.isEmpty ())
	user = "anonimo";
  if (password.isEmpty ())
	password = "anonimo";

  facturalux->setUserName (user);
  facturalux->setPassword (password);
  facturalux->setHostName (lineEditHost->text ());

  if (!facturalux->open ())
	{
	  QMessageBox::warning (this, tr ("Conexin fallida"),
							tr
							("Fallo al intentar abrir la base de datos 'facturalux':")
							+ "\n" +
							+facturalux->lastError ().driverText () + "\n" + facturalux->lastError ().databaseText (), QMessageBox::Ok, 0, 0);

	  error_ = true;
	  this->accept ();
	  return;
	}

  if (QSqlDatabase::database ()->lastError ().type () != QSqlError::None)
	{
	  QMessageBox::warning (this, tr ("Error en la base de datos"),
							QSqlDatabase::database ()->lastError ().
							driverText () + "\n" + QSqlDatabase::database ()->lastError ().databaseText (), QMessageBox::Ok, 0, 0);
	  error_ = true;
	  this->reject ();
	  return;
	}

  QSettings settings;
  QString keybase ("/facturalux/" VERSION "/");

  settings.writeEntry (keybase + "DBA/username", lineEditUser->text ());
  settings.writeEntry (keybase + "DBA/password", lineEditPassword->text ());
  settings.readEntry (keybase + "DBA/port", lineEditPort->text ());
  settings.readEntry (keybase + "DBA/hostname", lineEditHost->text ());

  this->accept ();
}

void
FLSessionDB::cancel ()
{
  this->reject ();
}
