/***************************************************************************
                          FLSessionDB.h  -  description
                             -------------------
    begin                : Sun Jul 1 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLSESSIONDB_H
#define FLSESSIONDB_H

#include <qwidget.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qsqldatabase.h>
#include <qsqlquery.h>

#include "FLWidgetConnectDB.h"

class FLTableMetaData;

/** Cuadro de dialogo para conectar con un la base de datos.

    	Esta clase es la encargada de mostrar un cuadro de dialogo
    	que nos permite conectar con la base de datos.
    	No permite elegir el driver de la base de datos, la maquina
    	a la que conectar, puerto, usuario y contrasea.

    	@author  Federico Albujer Zornoza
        @version 0.4 */
class FLSessionDB:public FLWidgetConnectDB
{
	Q_OBJECT
	
	public:

	/** constructor */
    	FLSessionDB (QWidget * parent = 0, const char *name = 0, WFlags fl = 0);

	/** destructor */
   	~FLSessionDB ();

   	/** Devuelve si hubo un error en el inicio de sesion */
   	bool error() const { return error_; }
   	
	private:

	/** Recibe seal cuando se pulsa botn cancelar conexin*/
  	void cancel ();

	/** Intenta realizar la conexion, recibe la seal cuando se pulsa el boton conectar */
  	void tryConnect ();
  	
  	/** Indica que ha habido un error */
  	bool error_;
};

#endif
