/***************************************************************************
                          FLUtil.cpp  -  description
                             -------------------
    begin                : Sun Jan 27 2002
    copyright            : (C) 2002 by Federico Albujer Zornoza,
                                Eloy Ordua Gonzlez, Andrs Otn
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLUtil.h"

FLUtil::FLUtil ()
{
}

FLUtil::~FLUtil ()
{
}

long
FLUtil::partInteger (double n)
{
  return (long) n;
}

long
FLUtil::partDecimal (double n)
{
  long entero;
  double decimal;

  entero = (long) n;
  decimal = n - entero;

  decimal = decimal * 100;

  return (long) decimal;
}

QString
FLUtil::enLetra (long n)
{
  QString buffer;

  if (n > 1000000000L)
	{
	  buffer = "Slo hay capacidad hasta mil millones";
	  return buffer;
	}

  if (n < 1000000L)
	{
	  buffer = centenamillar (n);
	  return buffer;
	}
  else
	{
	  if (n / 1000000L == 1)
		buffer = "un millon ";
	  else
		{
		  buffer = centenas ((long) (n / 1000000L));
		  buffer = buffer + " millones ";
		}
	}

  buffer = buffer + centenamillar (n % 1000000L);

  return buffer;
}

QString
FLUtil::enLetraMonedaEuro (double n)
{
  long entero = partInteger (n), decimal = partDecimal (n);

  QString res = QString::null;

  if (n > 0.00)
	{
	  if (entero > 0)
		res = enLetra (entero) + " euros";

	  if (entero > 0 && decimal > 0)
		res += " con " + enLetra (decimal) + " cntimos";

	  if (entero <= 0 && decimal > 0)
		res = enLetra (decimal) + " cntimos";
	}

  return res;
}

QString
FLUtil::unidades (long n)
{
  QStringList aUnidad;

  aUnidad << "" << "uno" << "dos" << "tres" << "cuatro" << "cinco" << "seis" << "siete" << "ocho" << "nueve";
  aUnidad << "diez" << "once" << "doce" << "trece" << "catorce" << "quince" << "dieciseis" << "diecisiete";
  aUnidad << "dieciocho" << "diecinueve" << "veinte" << "veintiun" << "veintidos" << "veintitres";
  aUnidad << "veinticuatro" << "veinticinco" << "veintiseis" << "veintisiete" << "veintiocho" << "veintinueve";

  QStringList::Iterator it = aUnidad.begin ();
  for (int i = 0; i < n; ++it, i++);

  return *it;
}

QString
FLUtil::centenamillar (long n)
{
  QString buffer;

  if (n < 10000)
	{
	  buffer = decenasmillar (n);
	  return buffer;
	}
  buffer = centenas (n / 1000);
  buffer = buffer + " mil ";
  buffer = buffer + centenas (n % 1000);

  return buffer;
}

QString
FLUtil::decenas (long n)
{
  QStringList aDecenas;
  QString buffer;

  QStringList::Iterator it;

  aDecenas << "" << "" << "" << "treinta" << "cuarenta" << "cincuenta" << "sesenta" << "setenta" << "ochenta";
  aDecenas << "noventa";

  if (n < 30)
	buffer = unidades (n);
  else
	{
	  it = aDecenas.begin ();
	  for (int i = 0; i < (n / 10L); ++it, i++);
	  buffer = (*it);
	  if (n % 10L)
		{
		  buffer = buffer + " y ";
		  buffer = buffer + unidades (n % 10L);
		}
	}

  return buffer;
}

QString
FLUtil::centenas (long n)
{
  QStringList aCentena;
  QString buffer;

  QStringList::Iterator it;

  aCentena << "" << "ciento" << "doscientos" << "trescientos" << "cuatrocientos" << "quinientos";
  aCentena << "seiscientos" << "setecientos" << "ochocientos" << "novecientos";

  if (n == 100)
	buffer = "cien";
  else if (n < 100)
	buffer = decenas (n);
  else
	{
	  it = aCentena.begin ();
	  for (int i = 0; i < (n / 100L); ++it, i++);
	  buffer = buffer + (*it);
	  buffer = buffer + " ";
	  buffer = buffer + decenas (n % 100);
	}
  return buffer;
}


QString FLUtil::unidadesmillar (long n)
{
  QString
	buffer;

  if (n < 1000)
	buffer = "";

  if (n / 1000 == 1)
	buffer = "mil ";

  if (n / 1000 > 1)
	{
	  buffer = unidades (n / 1000);
	  buffer = buffer + " mil ";
	}
  buffer = buffer + centenas (n % 1000);

  return buffer;
}


QString
FLUtil::decenasmillar (long n)
{
  QString buffer;

  if (n < 10000)
	{
	  buffer = unidadesmillar (n);
	  return buffer;
	}

  buffer = decenas (n / 1000);
  buffer = buffer + " mil ";
  buffer = buffer + centenas (n % 10000);

  return (buffer);
}

QChar
FLUtil::letraDni (long n)
{
  QString letras = "TRWAGMYFPDXBNJZSQVHLCKE";

  return letras.at (n % 23);
}

QChar
FLUtil::calcularDC (const QString & n)
{
  int Tabla[10] = {
	6,
	3,
	7,
	9,
	10,
	5,
	8,
	4,
	2,
	1
  };
  int DC, Suma = 0, nDigitos;

  nDigitos = n.length () - 1;
  for (uint ct = 1; ct <= n.length (); ct++)
	{
	  Suma += Tabla[nDigitos] * (n[ct - 1] - '0');
	  nDigitos--;
	}

  DC = 11 - (Suma % 11);
  if (DC == 11)
	DC = 0;
  else if (DC == 10)
	DC = 1;

  return QChar::QChar (DC + 48);
}

QString
FLUtil::dateDMAtoAMD (const QString & f)
{
  QString res = f;

  res = res.replace (QRegExp ("[\\s/-]"), "");

  if (res.length () <= 2)
	return (res.left (2));

  if (res.length () <= 4)
	return (res.right (res.length () - 2) + "-" + res.left (2));

  if (res.length () <= 8)
	return (res.right (res.length () - 4) + "-" + res.mid (2, 2) + "-" + res.left (2));

  return res;
}

QString
FLUtil::formatoMiles (const QString & s)
{
  QString tmp;
  int i, j;
  int offset;

  if (s.toDouble () < 0)
	offset = 1;
  else
	offset = 0;

  int pos = s.findRev (".");

  if (pos == -1)
	pos = s.length ();
  else
	tmp = s.mid (pos, s.length ());

  for (i = pos - 1, j = 0; i >= offset; i--)
	{
	  tmp = s.mid (i, 1) + tmp;
	  j++;
	  if ((j == 3) && (i - 1 >= offset))
		{
		  tmp = qApp->tr (",") + tmp;
		  j = 0;
		}
	}

  if (offset)
	tmp = "-" + tmp;

  return tmp;
}

bool
FLUtil::numCreditCard (QString num)
{
  int nSum = 0;
  int nRest, nCard;

  nCard = num.toInt ();
  nRest = nCard;

  for (int i = 0; i < 10; i = i + 2)
	{
	  nSum = nSum + (num.mid (i, 1)).toInt ();
	  nRest = (num.mid (i + 1, 1)).toInt () * 2;
	  if (nRest > 9)
		{
		  nRest = nRest - 9;
		}
	  nSum = nSum + nRest;
	}

  if (nSum % 10 == 0)
	return true;
  else
	return false;

}
