{
  Gestion LinEx FacturLinEx

  Copyright (C) 2000-2010,  Nicolas Lopez de Lerma Aymerich

  PuntoDev GNU S.L. <info@puntodev.com>

  Collaborators:
                 Antonio Domínguez Santos (adslinex)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit about;

{$mode objfpc}{$H+}

interface
uses
  SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, StdCtrls, IniFiles, LResources;
type

  { TAboutbox }

  TAboutbox = class(TForm)
    AboutPanel: TPanel;
    ButtonOk: TButton;
    Image1: TImage;
    ImageLogo: TImage;
    LabelPagProyecto: TLabel;
    MemoDesarrollo: TMemo;
    MemoAgradec: TMemo;
    MemoLicencia: TMemo;
    Notebook1: TNotebook;
    Desarrollo: TPage;
    Agradecimientos: TPage;
    Logo: TPage;
    Licencia: TPage;
    PanelBotonera: TPanel;
    LabelPaquete: TLabel;
    LabelVersion: TLabel;
    LabelAplicacion: TLabel;
    procedure ButtonOkClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
//    IniReader : TIniFile; //quitado por javi no se usa
//    Sections : TStringList;  //quitado por javi no se usa
//    Contents : TStringList; //quitado por javi no se usa
    procedure CargarLicense(RutaFichero: string);
  end;
  procedure AboutShow();
var
  Aboutbox: TAboutbox;
implementation
uses
  Global;
procedure AboutShow();
begin
  with TAboutbox.Create(Application) do
  begin
    ShowModal;
  end;
end;
procedure TAboutbox.FormCreate(Sender: TObject);
begin
  // Asignamos el valor de la versión del programa para mostrar en pantalla
  LabelVersion.Caption := '2.0.0-3 (20101231)';

  // A por estos datos y otros como Nombre del producto, versión, etc
  // podría acudir a un fichero
  MemoDesarrollo.Lines.Add('Nicolás López de Lerma Aymerich (nicolas@esdebian.es)');
  MemoDesarrollo.Lines.Add('');
  MemoDesarrollo.Lines.Add('Antonio Domínguez Santos (adslinex@esdebian.es)');
  MemoDesarrollo.Lines.Add('');
  MemoDesarrollo.Lines.Add('José Belenguer (xterm@esdebian.es)');
  MemoDesarrollo.Lines.Add('');
  MemoDesarrollo.Lines.Add('Jaime Alvarez Ares (xaime@esdebian.es)');
  MemoDesarrollo.Lines.Add('');
  MemoDesarrollo.Lines.Add('Elmo Calatayud Chumbes (ec.calatayud@gmail.com)');
  MemoDesarrollo.Lines.Add('');
  MemoDesarrollo.Lines.Add('Franciso Javier Perez Vidal (f-javier@esdebian.org)');

  MemoAgradec.Lines.Add('Testeo y otros aportes: ');
  MemoAgradec.Lines.Add('  Eduardo Maldonado');
  MemoAgradec.Lines.Add(' ');
//  MemoAgradec.Lines.Add('Incluir aquí los nombres');
  MemoAgradec.Lines.Add('Logos e infografías: ');
  MemoAgradec.Lines.Add('  María Domínguez Pozo');
  MemoAgradec.Lines.add('  Santiago Fernández Manzi');
  MemoAgradec.Lines.Add(' ');
  MemoAgradec.Lines.Add('Traducción: ');

  CargarLicense(ExtractFilePath(ParamStr(0))+'license');
  //CargarIcono(RUTA) está por definir, con este metodo sería mucho más fácil cambiar el icono
  //CargarColaboradores(RUTA), lo mismo que el anterior
end;

procedure TAboutbox.FormShow(Sender: TObject);
begin
  Exit;
  self.Canvas.Brush.Color:=  clSkyblue;
  AboutPanel.Canvas.Brush.Color:= clSkyBlue;
  Notebook1.Brush.Color:= clSkyBlue;

end;

//Acude a donde se coloque el fichero license y lo carga en un memo
//Si tenemos algún fallo en la lectura, no impide el resto de la carga
procedure TAboutbox.CargarLicense(RutaFichero: string);
var
  F: TextFile;
  Txt: String;
begin
  // Hay que definir donde se va a instalar este fichero
  MemoLicencia.Font.Size:=7;
  //{$IFDEF LINUX}
    //Opendialog1.FileName:='/usr/share/facturlinex2/license';
  //{$ELSE}
    //Opendialog1.FileName:='license';
  //{$ENDIF}
  // De momento he puesto el fichero license en Lee, no se exactamente cual es
  // el directorio de instalación en Win, y ese problema para la configuración
  // está resuelto.

  // Opendialog1.FileName:=RutaFichero;  //cambiado por javi para quitar opendialog
  // if not FileExists(Opendialog1.FileName) then exit; //cambiado por javi para quitar opendialog
  // AssignFile(F, Opendialog1.FileName); //cambiado por javi para quitar opendialog
  if not FileExists(RutaFichero) then exit; //añadido por javi para quitar opendialog
  AssignFile(F, RutaFichero); //añadido por javi para quitar opendialog
  Reset(F);
  while not EOF(F) do
  begin
    Readln(F, Txt);
    MemoLicencia.Lines.Add(Txt);
  end;
  CloseFile(F);
end;

procedure TAboutbox.ButtonOkClick(Sender: TObject);
begin
  Close;
end;

procedure TAboutbox.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  CloseAction := caFree;
end;


initialization
  {$i about.lrs}

end.
