/*
 * farsight-session.h - Headers for Farsight core API session objects
 *
 * Farsight Voice+Video library
 * Copyright (c) 2005 INdT
 *   @author: Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>.
 * Copyright 2005 Philippe Khalaf <burger@speedy.org>
 * Copyright 2005,2006 Collabora Ltd.
 * Copyright 2005,2006 Nokia Corp.
 *   @author: Rob Taylor <rob.taylor@collabora.co.uk>
 *   @author: Philippe Khalaf <philippe.kalaf@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_SESSION_H__
#define __FARSIGHT_SESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <gst/gstelement.h>

#include "farsight-plugin.h"
#include "farsight-codec.h"
#include "farsight-stream.h"

G_BEGIN_DECLS

/* TYPE MACROS */
#define FARSIGHT_TYPE_SESSION \
  (farsight_session_get_type())
#define FARSIGHT_SESSION(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), FARSIGHT_TYPE_SESSION, FarsightSession))
#define FARSIGHT_SESSION_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), FARSIGHT_TYPE_SESSION, FarsightSessionClass))
#define FARSIGHT_IS_SESSION(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), FARSIGHT_TYPE_SESSION))
#define FARSIGHT_IS_SESSION_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), FARSIGHT_TYPE_SESSION))
#define FARSIGHT_SESSION_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), FARSIGHT_TYPE_SESSION, FarsightSessionClass))

typedef struct _FarsightSession FarsightSession;
typedef struct _FarsightSessionClass FarsightSessionClass;
typedef struct _FarsightSessionPrivate FarsightSessionPrivate;

/**
 * SECTION:FarsightSession
 * @short_description: A media session, possibly containing multiple streams.
 */

/**
 * FarsightSessionError:
 * @ERROR_UNKNOWN: An unknown error occured
 *
 * Enum used to indicate an error condition.
 */
typedef enum
{
  ERROR_UNKNOWN
} FarsightSessionError;

struct _FarsightSessionClass
{
  GObjectClass parent_class;

  /*virtual methods */
  G_CONST_RETURN GList * (* list_supported_codecs) (FarsightSession *session);
  FarsightStream * (* create_stream) (FarsightSession *session,
                                      FarsightMediaType media_type,
                                      FarsightStreamDirection dir);
};

/**
 * FarsightSession:
 * 
 * @plugin: pointer to plugin that implements this session
 *
 * This represents a collection of streams that form a session with a single
 * wallclock base.
 */
struct _FarsightSession
{
  GObject parent;

  FarsightPlugin *plugin;

  /*< private >*/
  FarsightSessionPrivate *priv;
};

GType farsight_session_get_type (void);

FarsightSession *farsight_session_factory_make (const gchar *session_id);
void farsight_session_destroy (FarsightSession *session);

FarsightStream *farsight_session_create_stream (FarsightSession *session,
                                                FarsightMediaType media_type,
                                                FarsightStreamDirection dir);

G_CONST_RETURN GList * farsight_session_list_supported_codecs (FarsightSession * session);

/* FIXME: this should be in a different header */
gboolean farsight_session_register (FarsightPlugin *plugin, GType type);

G_END_DECLS

#endif
