INCLUDE (CheckIncludeFiles)

FIND_PATH(LIBTORRENTRB_INCLUDE_DIR libtorrent/session.hpp)
MARK_AS_ADVANCED(LIBTORRENTRB_INCLUDE_DIR)

FIND_LIBRARY(LIBTORRENTRB_LIBRARY torrent-rasterbar)
MARK_AS_ADVANCED(LIBTORRENTRB_LIBRARY)

IF(LIBTORRENTRB_INCLUDE_DIR AND LIBTORRENTRB_LIBRARY)
  SET(LIBTORRENTRB_FOUND 1)
  SET(LIBTORRENTRB_LIBRARIES ${LIBTORRENTRB_LIBRARY} -lboost_date_time-mt)
  SET(LIBTORRENTRB_INCLUDE_DIRS ${LIBTORRENTRB_INCLUDE_DIR}/libtorrent)
ELSE(LIBTORRENTRB_INCLUDE_DIR AND LIBTORRENTRB_LIBRARY)
  SET(LIBTORRENTRB_FOUND 0)
  SET(LIBTORRENTRB_LIBRARIES)
  SET(LIBTORRENTRB_INCLUDE_DIRS)
ENDIF(LIBTORRENTRB_INCLUDE_DIR AND LIBTORRENTRB_LIBRARY)

IF(NOT LIBTORRENTRB_FOUND)
  SET(LIBTORRENTRB_DIR_MESSAGE
      "LIBTORRENT was not found. Make sure LIBTORRENTRB_LIBRARY and LIBTORRENTRB_INCLUDE_DIR are set.")
  IF(NOT LIBTORRENTRB_FIND_QUIETLY)
    MESSAGE(STATUS "${LIBTORRENTRB_DIR_MESSAGE}")
  ELSE(NOT LIBTORRENTRB_FIND_QUIETLY)
    IF(LIBTORRENTRB_FIND_REQUIRED)
      MESSAGE(FATAL_ERROR "${LIBTORRENTRB_DIR_MESSAGE}")
    ENDIF(LIBTORRENTRB_FIND_REQUIRED)
  ENDIF(NOT LIBTORRENTRB_FIND_QUIETLY)
ENDIF(NOT LIBTORRENTRB_FOUND)


