/* $Id: NextStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __NEXT_STAT_HPP_INCLUDED
#define __NEXT_STAT_HPP_INCLUDED

#include "frontend/ast/ConditionedStat.hpp"
#include "frontend/ast/Expression.hpp"
#include "frontend/ast/LoopStat.hpp"
#include "frontend/ast/SimpleName.hpp"


namespace ast {

/** a vhdl next statement */
class NextStat : public ConditionedStat {
public:
	//! c'tor
	/** @param optCond condition that must be met (optional).
          * @param optLabel label that identifies the referring loop 
          *        (optional).
	  * @param loc location of the NextStat.
          */
	NextStat(
		Expression *optCond, 
		SimpleName *optLabel,
		Location loc
		) :	ConditionedStat(optCond, loc),
			loopLabel(optLabel),
			referredLoop(NULL) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "NEXT";
		if (this->loopLabel) {
			stream << ' ' << this->loopLabel;
		}
		stream << ';';
	}


	/** Identifier of enclosing loop */
	SimpleName *loopLabel;

	/** loop statement being referred to. */
	LoopStat *referredLoop;

protected:
	/** Destructor */
	virtual ~NextStat() {
		util::MiscUtil::terminate(loopLabel);
		//FIXME?
		util::MiscUtil::terminate(referredLoop);
	}
};
	
}; /* namespace ast */

#endif /* __NEXT_STAT_HPP_INCLUDED */
