/* $Id: SubtypeIndication.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/SubtypeIndication.hpp"
#include <cassert>
#include "frontend/misc/Symbol.hpp"

namespace ast {

SubtypeIndication::SubtypeIndication(
	Name *typeMark,
	Location loc
	) : 	TypeDeclaration(NULL, loc, BASE_TYPE_UNSET),
		typeName(typeMark),
		constraint(NULL),
		indexConstraint(NULL),
		resolutionFunction(NULL),
		declaration(NULL) {

	if (typeMark && typeMark->candidates.size() == 1) {
		Symbol *sym = typeMark->candidates.front();
		this->declaration = dynamic_cast<const TypeDeclaration*>(
							&sym->declaration);
		assert(this->declaration);
		this->baseType = this->declaration->baseType;
	}
}

SubtypeIndication::SubtypeIndication(
	const TypeDeclaration *byType,
	Location loc
) :		TypeDeclaration(NULL, loc, byType->baseType),
		typeName(NULL),
		constraint(NULL),
		indexConstraint(NULL),
		resolutionFunction(NULL),
		declaration(byType)
{
}

}; /* namespace ast */
