/* $Id: Data.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __DATA_HPP_INCLUDED
#define __DATA_HPP_INCLUDED

#include <list>
#include "intermediate/container/TypeElement.hpp"

namespace intermediate {

//! different storage types (objects lying somewhere on the heap or stack)
enum StorageType {
	//! plain variable.
	STORAGE_TYPE_VARIABLE,
	//! a driver of a signal
	STORAGE_TYPE_DRIVER,
	//! a signal (which however first needs to be created)
	STORAGE_TYPE_SIGNAL
};


//! declaration of a data object
class Data : public Node {
public:
	//! c'tor 
	/** @param n name of the data object
	 *  @param t type element of the data object
	 */
	Data(
		std::string n,
		enum StorageType st,
		TypeElement *t
		) : 	name(n), storage(st), dataType(t) {}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}
	
	/** name of the data object */
	std::string name;
	/** storage type */
	enum StorageType storage;
	/** type of the data object, eventually with initializer */
	TypeElement *dataType;

protected:
	virtual ~Data() {
		util::MiscUtil::terminate(this->dataType);
	}
};

}; /* namespace intermediate */

#endif /* __DATA_HPP_INCLUDED */
