/* $Id: SimpleName.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/SimpleName.hpp"
#include <cassert>
#include "frontend/misc/Symbol.hpp"
#include "frontend/ast/SignalDeclaration.hpp"

namespace ast {

bool
SimpleName::isSignal(void) const
{
	assert(this->candidates.size() >= 1);

	if (this->candidates.size() != 1) {
		// overloaded -> function or procedure
		return false;
	}
	
	switch (this->candidates.front()->type) {
	case SYMBOL_SIGNAL:
	case SYMBOL_PORT:
		return true;

	case SYMBOL_PARAMETER: {
		// might be a signal, check
		const SignalDeclaration *sig = 
			dynamic_cast<const SignalDeclaration*>(
				&this->candidates.front()->declaration);
		if (sig != NULL) {
			return true;
		}

		break;
	    }
	default:
		break;
	}

	return false;
}

}; /* namespace ast */
