/* $Id: fauhdli.h 4351 2009-02-05 12:48:13Z sand $
 * Interpreter library. External API
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __FAUHDLI_H_INCLUDED
#define __FAUHDLI_H_INCLUDED

#include <stdbool.h>
/* FIXME use <..> here! */
#include "basetypes.h"

/** forward declaration of struct fauhdli, which is opaque to external 
 *  users. */
struct fauhdli;

/** any directly used VHDL value. */
union fauhdli_value {
	/** integer value */
	universal_integer univ_int;
	/** real value */
	universal_real univ_real;
	/** pointer value */
	void *pointer;
};

/** create the VHDL interpreter.
 *  @param parse_file intermediate code file to parse.
 *  @param trace_file name of vcd trace file (to trace signals of top_entity)
 *         or NULL, if no output is desired.
 *  @param debug debugging output enabled/disabled?
 *  @return fauhdli instance.
 */
extern
__attribute__((visibility("default")))
struct fauhdli *
fauhdli_create(const char *parse_file, const char *trace_file, bool debug);

/** destroy the fauhdli instance.
 *  @param instance fauhdli instance.
 */
extern void
__attribute__((visibility("default")))
fauhdli_destroy(struct fauhdli *instance);

/** initialize/run simulator
 *  @param instance simulator instance.
 *  @param top_entity start simulation with entity called like this.
 */
extern void
__attribute__((visibility("default")))
fauhdli_init(struct fauhdli *instance, const char *top_entity);


/** find out the foreign signal id for a signal
 *  @param _sig pointer to signal instance.
 *  @return foreign signal id
 */
extern
__attribute__((visibility("default")))
unsigned int
fauhdli_get_sig_id(const void *_sig);

/** find out the foreign signal id for a driver
 *  @param _drv pointer to driver instance.
 *  @return foreign signal id
 */
extern
__attribute__((visibility("default")))
unsigned int
fauhdli_get_sig_id_driver(const void *_drv);

#endif /* __FAUHDLI_H_INCLUDED */
